/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.protobuf.ProtobufRDF;
import org.apache.jena.riot.system.PrintingStreamRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWriterFactory;
import org.apache.jena.riot.system.StreamTriplesOnly;
import org.apache.jena.riot.thrift.ThriftRDF;
import org.apache.jena.riot.writer.StreamWriterTriX;
import org.apache.jena.riot.writer.WriterStreamRDFBlocks;
import org.apache.jena.riot.writer.WriterStreamRDFFlat;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSystem;

public class StreamRDFWriter {
    private static StreamRDFWriterFactory streamWriterFactoryBlocks;
    private static StreamRDFWriterFactory streamWriterFactoryFlat;
    private static StreamRDFWriterFactory streamWriterFactoryTriplesQuads;
    private static StreamRDFWriterFactory streamWriterFactoryTriplesQuadsAscii;
    private static StreamRDFWriterFactory streamWriterFactoryProtobuf;
    private static StreamRDFWriterFactory streamWriterFactoryThrift;
    private static StreamRDFWriterFactory streamWriterFactoryTriX;
    private static StreamRDFWriterFactory streamWriterFactoryNull;
    private static StreamRDFWriterFactory streamWriterFactoryRaw;
    private static WriterRegistry<StreamRDFWriterFactory> registry;

    public static void register(Lang lang, RDFFormat format) {
        registry.register(lang, format);
    }

    public static void register(RDFFormat serialization, StreamRDFWriterFactory streamWriterFactory) {
        registry.register(serialization, streamWriterFactory);
    }

    public static RDFFormat defaultSerialization(Lang lang) {
        return registry.defaultSerialization(lang);
    }

    public static StreamRDF getWriterStream(OutputStream output, Lang lang) {
        return StreamRDFWriter.getWriterStream(output, lang, null);
    }

    public static StreamRDF getWriterStream(OutputStream output, Lang lang, Context context2) {
        RDFFormat fmt = registry.choose(lang);
        return StreamRDFWriter.getWriterStream(output, fmt, context2);
    }

    public static StreamRDF getWriterStream(OutputStream output, RDFFormat format) {
        return StreamRDFWriter.getWriterStream(output, format, null);
    }

    public static StreamRDF getWriterStream(OutputStream output, RDFFormat format, Context context2) {
        StreamRDFWriterFactory x = registry.get(format);
        if (x == null) {
            return null;
        }
        if (context2 == null) {
            context2 = RIOT.getContext().copy();
        }
        StreamRDF stream = x.create(output, format, context2);
        if (!RDFLanguages.isQuads(format.getLang())) {
            stream = StreamRDFWriter.triplesOnly(stream);
        }
        return stream;
    }

    private static StreamRDF triplesOnly(StreamRDF stream) {
        return StreamTriplesOnly.exceptionOnQuads(stream);
    }

    public static boolean registered(Lang lang) {
        RDFFormat fmt = registry.defaultSerialization(lang);
        return registry.contains(fmt);
    }

    public static boolean registered(RDFFormat format) {
        return registry.contains(format);
    }

    public static Collection<RDFFormat> registered() {
        return Collections.unmodifiableSet(StreamRDFWriter.registry.formatRegistry.keySet());
    }

    public static void write(OutputStream output, Graph graph, Lang lang, Context context2) {
        RDFFormat fmt = registry.choose(lang);
        StreamRDFWriter.write(output, graph, fmt, context2);
    }

    public static void write(OutputStream output, Graph graph, RDFFormat format) {
        StreamRDFWriter.write(output, graph, format, null);
    }

    public static void write(OutputStream output, Graph graph, RDFFormat format, Context context2) {
        StreamRDF stream = StreamRDFWriter.getWriterStream(output, format, context2);
        StreamRDFOps.graphToStream(graph, stream);
    }

    public static void write(OutputStream output, DatasetGraph datasetGraph, Lang lang) {
        StreamRDFWriter.write(output, datasetGraph, lang, null);
    }

    public static void write(OutputStream output, DatasetGraph datasetGraph, Lang lang, Context context2) {
        RDFFormat fmt = registry.choose(lang);
        StreamRDFWriter.write(output, datasetGraph, fmt, context2);
    }

    public static void write(OutputStream output, DatasetGraph datasetGraph, RDFFormat format, Context context2) {
        StreamRDF stream = StreamRDFWriter.getWriterStream(output, format, context2);
        StreamRDFOps.datasetToStream(datasetGraph, stream);
    }

    static {
        JenaSystem.init();
        streamWriterFactoryBlocks = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                return new WriterStreamRDFBlocks(output, context2);
            }
        };
        streamWriterFactoryFlat = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                return new WriterStreamRDFFlat(output, context2);
            }
        };
        streamWriterFactoryTriplesQuads = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                AWriter w = IO.wrapUTF8(output);
                return new WriterStreamRDFPlain(w, CharSpace.UTF8);
            }
        };
        streamWriterFactoryTriplesQuadsAscii = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                AWriter w = IO.wrapUTF8(output);
                return new WriterStreamRDFPlain(w, CharSpace.ASCII);
            }
        };
        streamWriterFactoryProtobuf = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                boolean withValues = RDFFormat.RDF_PROTO_VALUES.equals(format);
                return ProtobufRDF.streamToOutputStream(output, withValues);
            }
        };
        streamWriterFactoryThrift = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                boolean withValues = RDFFormat.RDF_THRIFT_VALUES.equals(format);
                return ThriftRDF.streamToOutputStream(output, withValues);
            }
        };
        streamWriterFactoryTriX = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                return new StreamWriterTriX(output, null);
            }
        };
        streamWriterFactoryNull = new StreamRDFWriterFactory(){

            @Override
            public StreamRDF create(OutputStream output, RDFFormat format, Context context2) {
                return StreamRDFLib.sinkNull();
            }
        };
        streamWriterFactoryRaw = (output, format, context2) -> new PrintingStreamRDF(output);
        registry = new WriterRegistry();
        StreamRDFWriter.register(Lang.TURTLE, RDFFormat.TURTLE_BLOCKS);
        StreamRDFWriter.register(Lang.TRIG, RDFFormat.TRIG_BLOCKS);
        StreamRDFWriter.register(Lang.NTRIPLES, RDFFormat.NTRIPLES);
        StreamRDFWriter.register(Lang.NQUADS, RDFFormat.NQUADS);
        StreamRDFWriter.register(Lang.RDFPROTO, RDFFormat.RDF_PROTO);
        StreamRDFWriter.register(Lang.RDFTHRIFT, RDFFormat.RDF_THRIFT);
        StreamRDFWriter.register(Lang.TRIX, RDFFormat.TRIX);
        StreamRDFWriter.register(Lang.RDFNULL, RDFFormat.RDFNULL);
        StreamRDFWriter.register(Lang.RDFRAW, RDFFormat.RDFRAW);
        StreamRDFWriter.register(RDFFormat.TURTLE_BLOCKS, streamWriterFactoryBlocks);
        StreamRDFWriter.register(RDFFormat.TURTLE_FLAT, streamWriterFactoryFlat);
        StreamRDFWriter.register(RDFFormat.TRIG_BLOCKS, streamWriterFactoryBlocks);
        StreamRDFWriter.register(RDFFormat.TRIG_FLAT, streamWriterFactoryFlat);
        StreamRDFWriter.register(RDFFormat.NTRIPLES, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NTRIPLES_UTF8, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NTRIPLES_ASCII, streamWriterFactoryTriplesQuadsAscii);
        StreamRDFWriter.register(RDFFormat.NQUADS, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NQUADS_UTF8, streamWriterFactoryTriplesQuads);
        StreamRDFWriter.register(RDFFormat.NQUADS_ASCII, streamWriterFactoryTriplesQuadsAscii);
        StreamRDFWriter.register(RDFFormat.RDF_PROTO, streamWriterFactoryProtobuf);
        StreamRDFWriter.register(RDFFormat.RDF_PROTO_VALUES, streamWriterFactoryProtobuf);
        StreamRDFWriter.register(RDFFormat.RDF_THRIFT, streamWriterFactoryThrift);
        StreamRDFWriter.register(RDFFormat.RDF_THRIFT_VALUES, streamWriterFactoryThrift);
        StreamRDFWriter.register(RDFFormat.TRIX, streamWriterFactoryTriX);
        StreamRDFWriter.register(RDFFormat.RDFNULL, streamWriterFactoryNull);
        StreamRDFWriter.register(RDFFormat.RDFRAW, streamWriterFactoryRaw);
    }

    public static class WriterRegistry<T> {
        private Map<RDFFormat, T> formatRegistry = new HashMap<RDFFormat, T>();
        private Map<Lang, RDFFormat> langToFormat = new HashMap<Lang, RDFFormat>();

        public void register(Lang lang, RDFFormat format) {
            this.langToFormat.put(lang, format);
        }

        public void register(RDFFormat serialization, T streamWriterFactory) {
            this.formatRegistry.put(serialization, streamWriterFactory);
        }

        public T get(RDFFormat serialization) {
            return this.formatRegistry.get(serialization);
        }

        public boolean contains(RDFFormat serialization) {
            return this.formatRegistry.containsKey(serialization);
        }

        public RDFFormat defaultSerialization(Lang lang) {
            return this.langToFormat.get(lang);
        }

        public RDFFormat choose(Lang lang) {
            RDFFormat fmt = this.defaultSerialization(lang);
            if (fmt == null) {
                throw new RiotException("No serialization for language " + String.valueOf(lang));
            }
            return fmt;
        }
    }
}

