/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.describe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.describe.DescribeBNodeClosureFactory;
import org.apache.jena.sparql.core.describe.DescribeHandler;
import org.apache.jena.sparql.core.describe.DescribeHandlerFactory;
import org.apache.jena.sparql.util.Context;

public class DescribeHandlerRegistry {
    private static DescribeHandlerRegistry globalRegistry = null;
    private List<DescribeHandlerFactory> registry = new ArrayList<DescribeHandlerFactory>();

    private DescribeHandlerRegistry() {
    }

    private static DescribeHandlerRegistry standardRegistry() {
        DescribeHandlerRegistry reg = new DescribeHandlerRegistry();
        reg.add(new DescribeBNodeClosureFactory());
        return reg;
    }

    public static DescribeHandlerRegistry get(Context context2) {
        if (context2 == null) {
            return null;
        }
        return (DescribeHandlerRegistry)ARQ.getContext().get(ARQConstants.registryDescribeHandlers);
    }

    public static void set(Context context2, DescribeHandlerRegistry reg) {
        context2.set(ARQConstants.registryDescribeHandlers, reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DescribeHandlerRegistry get() {
        DescribeHandlerRegistry reg = DescribeHandlerRegistry.get(ARQ.getContext());
        if (reg != null) return reg;
        Class<DescribeHandlerRegistry> clazz = DescribeHandlerRegistry.class;
        synchronized (DescribeHandlerRegistry.class) {
            if (reg != null) return reg;
            reg = DescribeHandlerRegistry.standardRegistry();
            DescribeHandlerRegistry.set(ARQ.getContext(), reg);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reg;
        }
    }

    public void add(DescribeHandlerFactory handlerFactory) {
        this.registry.add(0, handlerFactory);
    }

    public void remove(DescribeHandlerFactory handlerFactory) {
        this.registry.remove(handlerFactory);
    }

    public void clear() {
        this.registry.clear();
    }

    public List<DescribeHandler> newHandlerList() {
        ArrayList<DescribeHandler> a = new ArrayList<DescribeHandler>(this.registry.size());
        Iterator<DescribeHandlerFactory> iter = this.handlers();
        while (iter.hasNext()) {
            DescribeHandlerFactory f = iter.next();
            a.add(f.create());
        }
        return a;
    }

    public Iterator<DescribeHandlerFactory> handlers() {
        return this.registry.iterator();
    }
}

