/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.pdf.CMSProcessableInputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFSignParams;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.TempResourceURIGenerator;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class PDFSignature {
    private static final int SIZE_OF_CONTENTS = 18944;
    private static final TempResourceURIGenerator TEMP_URI_GENERATOR = new TempResourceURIGenerator("pdfsign2");
    private Perms perms;
    private PDFRoot root;
    private PrivateKey privateKey;
    private long startOfDocMDP;
    private long startOfContents;
    private FOUserAgent userAgent;
    private URI tempURI;
    private PDFSignParams signParams;

    public PDFSignature(PDFRoot root, FOUserAgent userAgent, PDFSignParams signParams) {
        this.root = root;
        this.userAgent = userAgent;
        this.signParams = signParams;
        this.perms = new Perms(root, new DocMDP());
        root.put("Perms", this.perms);
        this.tempURI = TEMP_URI_GENERATOR.generate();
    }

    public void add(PDFPage page) {
        SigField sigField = new SigField(this.perms, page, this.root);
        this.root.put("AcroForm", new AcroForm(sigField));
        page.addAnnotation(sigField);
    }

    public void signPDF(URI uri, OutputStream os) throws IOException {
        try (InputStream pdfIS = this.getTempIS(uri);){
            pdfIS.mark(Integer.MAX_VALUE);
            String byteRangeValues = "0 1000000000 1000000000 1000000000";
            String byteRange = "\n  /ByteRange [" + byteRangeValues + "]";
            int pdfLength = pdfIS.available();
            long offsetToPDFEnd = this.startOfContents + 18944L + 2L + (long)byteRange.length();
            long endOfPDFSize = (long)pdfLength - offsetToPDFEnd;
            String byteRangeValues2 = String.format("0 %s %s %s", this.startOfContents, this.startOfContents + 18944L + 2L, (long)byteRange.length() + endOfPDFSize);
            byteRange = "\n  /ByteRange [" + byteRangeValues2 + "]";
            String byteRangePadding = new String(new char[byteRangeValues.length() - byteRangeValues2.length()]).replace("\u0000", " ");
            try (OutputStream editedPDF = this.getTempOS();){
                IOUtils.copyLarge(pdfIS, editedPDF, 0L, this.startOfContents);
                editedPDF.write(byteRange.getBytes("UTF-8"));
                editedPDF.write(byteRangePadding.getBytes("UTF-8"));
                IOUtils.copyLarge(pdfIS, editedPDF, offsetToPDFEnd - this.startOfContents, Long.MAX_VALUE);
            }
            pdfIS.reset();
            IOUtils.copyLarge(pdfIS, os, 0L, this.startOfContents);
            var15_15 = null;
            try (InputStream is = this.getTempIS(this.tempURI);){
                byte[] signed = this.readPKCS(is);
                String signedHexPadding = new String(new char[18944 - signed.length * 2]).replace("\u0000", "0");
                String signedHex = "<" + PDFText.toHex(signed, false) + signedHexPadding + ">";
                os.write(signedHex.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                var15_15 = throwable;
                throw throwable;
            }
            os.write(byteRange.getBytes("UTF-8"));
            os.write(byteRangePadding.getBytes("UTF-8"));
            IOUtils.copyLarge(pdfIS, os, offsetToPDFEnd - this.startOfContents, Long.MAX_VALUE);
        }
    }

    private OutputStream getTempOS() throws IOException {
        return new BufferedOutputStream(this.userAgent.getResourceResolver().getOutputStream(this.tempURI));
    }

    private InputStream getTempIS(URI uri) throws IOException {
        return new BufferedInputStream((InputStream)this.userAgent.getResourceResolver().getResource(uri));
    }

    private byte[] readPKCS(InputStream pdf) throws IOException {
        try {
            char[] password = this.signParams.getPassword().toCharArray();
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            try (Resource is = this.userAgent.getResourceResolver().getResource(this.signParams.getPkcs12());){
                keystore.load((InputStream)is, password);
            }
            Certificate[] certificates = this.readKeystore(keystore, password);
            return this.sign(pdf, certificates);
        }
        catch (URISyntaxException | GeneralSecurityException | CMSException | OperatorException e) {
            throw new RuntimeException(e);
        }
    }

    private Certificate[] readKeystore(KeyStore keystore, char[] password) throws GeneralSecurityException, IOException {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            this.privateKey = (PrivateKey)keystore.getKey(alias, password);
            Certificate[] certChain = keystore.getCertificateChain(alias);
            if (certChain == null) continue;
            Certificate cert = certChain[0];
            if (cert instanceof X509Certificate) {
                ((X509Certificate)cert).checkValidity();
            }
            return certChain;
        }
        throw new IOException("Could not find certificate");
    }

    private byte[] sign(InputStream content, Certificate[] certChain) throws GeneralSecurityException, OperatorException, CMSException, IOException {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        X509Certificate cert = (X509Certificate)certChain[0];
        ContentSigner sha2Signer = new JcaContentSignerBuilder("SHA256WithRSA").build(this.privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(sha2Signer, cert));
        gen.addCertificates((Store)new JcaCertStore(Arrays.asList(certChain)));
        CMSProcessableInputStream msg = new CMSProcessableInputStream(content);
        CMSSignedData signedData = gen.generate((CMSTypedData)msg, false);
        return signedData.getEncoded();
    }

    static class AcroForm
    extends PDFDictionary {
        AcroForm(SigField sigField) {
            PDFArray fields = new PDFArray();
            fields.add(sigField);
            this.put("Fields", fields);
            this.put("SigFlags", 3);
        }
    }

    static class FormXObject
    extends PDFStream {
        FormXObject(PDFRoot root) {
            root.getDocument().registerObject(this);
            this.put("Length", 0);
            this.put("Type", new PDFName("XObject"));
            this.put("Subtype", new PDFName("Form"));
            this.put("BBox", new PDFRectangle(0, 0, 0, 0));
        }
    }

    static class AP
    extends PDFDictionary {
        AP(PDFRoot root) {
            this.put("N", new FormXObject(root));
        }
    }

    static class SigField
    extends PDFDictionary {
        SigField(Perms perms, PDFPage page, PDFRoot root) {
            root.getDocument().registerObject(this);
            this.put("FT", new PDFName("Sig"));
            this.put("Type", new PDFName("Annot"));
            this.put("Subtype", new PDFName("Widget"));
            this.put("F", 132);
            this.put("T", "Signature1");
            this.put("TU", "Signature1");
            this.put("Rect", new PDFRectangle(0, 0, 0, 0));
            this.put("V", perms.docMDP);
            this.put("P", new PDFReference(page));
            this.put("AP", new AP(root));
        }
    }

    static class Perms
    extends PDFDictionary {
        DocMDP docMDP;

        Perms(PDFRoot root, DocMDP docMDP) {
            this.docMDP = docMDP;
            root.getDocument().registerObject(docMDP);
            this.put("DocMDP", docMDP);
        }
    }

    class DocMDP
    extends PDFDictionary {
        DocMDP() {
            this.put("Type", new PDFName("Sig"));
            this.put("Filter", new PDFName("Adobe.PPKLite"));
            this.put("SubFilter", new PDFName("adbe.pkcs7.detached"));
            if (PDFSignature.this.signParams.getName() != null) {
                this.put("Name", PDFSignature.this.signParams.getName());
            }
            if (PDFSignature.this.signParams.getLocation() != null) {
                this.put("Location", PDFSignature.this.signParams.getLocation());
            }
            if (PDFSignature.this.signParams.getReason() != null) {
                this.put("Reason", PDFSignature.this.signParams.getReason());
            }
            this.put("M", PDFInfo.formatDateTime(new Date()));
            PDFArray array = new PDFArray();
            array.add(new SigRef());
            this.put("Reference", array);
            this.put("Contents", new Contents());
            this.put("ByteRange", new PDFArray(0, 1000000000, 1000000000, 1000000000));
        }

        @Override
        public int output(OutputStream stream) throws IOException {
            if (stream instanceof CountingOutputStream) {
                CountingOutputStream countingOutputStream = (CountingOutputStream)stream;
                PDFSignature.this.startOfDocMDP = countingOutputStream.getByteCount();
                return super.output(stream);
            }
            throw new IOException("Disable pdf linearization");
        }

        @Override
        public boolean supportsObjectStream() {
            return false;
        }
    }

    class Contents
    extends PDFObject {
        Contents() {
        }

        @Override
        protected String toPDFString() {
            return PDFText.toHex(new byte[9472]);
        }

        @Override
        public int output(OutputStream stream) throws IOException {
            CountingOutputStream countingOutputStream = (CountingOutputStream)stream;
            PDFSignature.this.startOfContents = PDFSignature.this.startOfDocMDP + countingOutputStream.getByteCount();
            return super.output(stream);
        }
    }

    static class SigRef
    extends PDFDictionary {
        SigRef() {
            this.put("Type", new PDFName("SigRef"));
            this.put("TransformMethod", new PDFName("DocMDP"));
            this.put("DigestMethod", new PDFName("SHA1"));
            this.put("TransformParams", new TransformParams());
        }
    }

    static class TransformParams
    extends PDFDictionary {
        TransformParams() {
            this.put("Type", new PDFName("TransformParams"));
            this.put("P", 2);
            this.put("V", new PDFName("1.2"));
        }
    }
}

