/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.ISubresourceHeaderItem;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.value.AttributeMap;

public abstract class AbstractCssReferenceHeaderItem
extends CssHeaderItem
implements ISubresourceHeaderItem {
    private final String media;
    private final String rel;
    private CrossOrigin crossOrigin;
    private String integrity;

    public AbstractCssReferenceHeaderItem(String media, String rel) {
        this.media = media;
        this.rel = rel;
    }

    @Override
    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    @Override
    public AbstractCssReferenceHeaderItem setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
        return this;
    }

    public String getMedia() {
        return this.media;
    }

    public String getRel() {
        return this.rel;
    }

    @Override
    public String getIntegrity() {
        return this.integrity;
    }

    @Override
    public AbstractCssReferenceHeaderItem setIntegrity(String integrity) {
        this.integrity = integrity;
        return this;
    }

    protected final void internalRenderCSSReference(Response response, String url) {
        Args.notEmpty(url, "url");
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute("rel", this.getRel() == null ? "stylesheet" : this.getRel());
        attributes.putAttribute("type", "text/css");
        attributes.putAttribute("href", url);
        attributes.putAttribute("id", this.getId());
        attributes.putAttribute("media", this.getMedia());
        attributes.putAttribute("crossOrigin", this.crossOrigin == null ? null : this.crossOrigin.getRealName());
        attributes.putAttribute("integrity", this.integrity);
        attributes.putAttribute("nonce", this.getNonce());
        CssUtils.writeLink(response, attributes);
        response.write("\n");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractCssReferenceHeaderItem that = (AbstractCssReferenceHeaderItem)o;
        return Objects.equals(this.integrity, that.integrity) && Objects.equals((Object)this.crossOrigin, (Object)that.crossOrigin);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.crossOrigin != null ? this.crossOrigin.hashCode() : 0);
        result = 31 * result + (this.integrity != null ? this.integrity.hashCode() : 0);
        return result;
    }
}

