/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import org.apache.uima.ruta.ide.ui.RutaPartitions;
import org.apache.uima.ruta.ide.ui.hierarchy.RutaHierarchyInformationControl;
import org.apache.uima.ruta.ide.ui.text.ExternalTypeHyperlinkDetector;
import org.apache.uima.ruta.ide.ui.text.RutaAutoEditStrategy;
import org.apache.uima.ruta.ide.ui.text.RutaCodeScanner;
import org.apache.uima.ruta.ide.ui.text.RutaOutlineInformationControl;
import org.apache.uima.ruta.ide.ui.text.RutaStringScanner;
import org.apache.uima.ruta.ide.ui.text.RutaTextTools;
import org.apache.uima.ruta.ide.ui.text.completion.RutaContentAssistPreference;
import org.apache.uima.ruta.ide.ui.text.completion.RutaScriptCompletionProcessor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.text.ScriptElementProvider;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RutaSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private RutaTextTools fTextTools;
    private RutaCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fCommentScanner;

    public RutaSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return RutaPartitions.RUTA_PARTITION_TYPES;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("formatter.tabulation.size");
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new RutaCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new RutaStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        RutaScriptCompletionProcessor scriptProcessor = new RutaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        RutaScriptCompletionProcessor singleLineProcessor = new RutaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__ruta_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)singleLineProcessor, "__ruta_comment");
        RutaScriptCompletionProcessor stringProcessor = new RutaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__ruta_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__ruta_string");
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public String getCommentPrefix() {
        return "//";
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruta_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruta_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruta_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruta_comment");
        return reconciler;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event);
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new RutaHierarchyInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    public IInformationPresenter getHierarchyPresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        if (this.getEditor() != null && this.getEditor().getEditorInput() != null && EditorUtility.getEditorInputModelElement((IEditorPart)this.getEditor(), (boolean)true) == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator((ISourceViewer)sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        ScriptElementProvider provider = new ScriptElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.getEditor() == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        for (int i = 0; i < inheritedDetectorsLength; ++i) {
            detectors[i] = inheritedDetectors[i];
        }
        detectors[inheritedDetectorsLength] = new ExternalTypeHyperlinkDetector(this.getEditor());
        return detectors;
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new RutaOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        return new IAutoEditStrategy[]{new RutaAutoEditStrategy(this.fPreferenceStore, partitioning)};
    }

    protected void initializeQuickOutlineContexts(InformationPresenter presenter, IInformationProvider provider) {
        presenter.setInformationProvider(provider, "__ruta_comment");
        presenter.setInformationProvider(provider, "__ruta_string");
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return RutaContentAssistPreference.getDefault();
    }
}

