/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.insd.edit;

import java.io.File;
import java.io.IOException;
import org.apache.uima.pear.PearException;
import org.apache.uima.pear.nature.ProjectCustomizer;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.SAXException;

public class PearInstallationDescriptor {
    public static final String INSTALLATION_DESCRIPTOR_PATH = "metadata/install.xml";

    public static void saveInstallationDescriptor(IContainer currentContainer, InstallationDescriptor insd) throws CoreException, IOException {
        IFile installFile = currentContainer.getFile((IPath)new Path(INSTALLATION_DESCRIPTOR_PATH));
        installFile.setContents(InstallationDescriptorHandler.getInstallationDescriptorAsStream((InstallationDescriptor)insd), false, true, null);
    }

    public static InstallationDescriptor getInstallationDescriptor(IContainer currentContainer) throws IOException, SAXException, CoreException, PearException {
        InstallationDescriptor insd = new InstallationDescriptor();
        InstallationDescriptorHandler insdh = new InstallationDescriptorHandler();
        IFile installFile = currentContainer.getFile((IPath)new Path(INSTALLATION_DESCRIPTOR_PATH));
        if (installFile.exists()) {
            insdh.parse(installFile.getContents());
            insd = insdh.getInstallationDescriptor();
        } else {
            PearInstallationDescriptor.createInstallationDescriptor(currentContainer, insd, false);
        }
        return insd;
    }

    public static void createInstallationDescriptor(IContainer newContainer, InstallationDescriptor insd, boolean overrideContentIfExist) throws PearException {
        try {
            ProjectCustomizer.createFile(newContainer, INSTALLATION_DESCRIPTOR_PATH, InstallationDescriptorHandler.getInstallationDescriptorAsStream((InstallationDescriptor)insd), overrideContentIfExist);
        }
        catch (Throwable e) {
            PearException subEx = new PearException("The Installation Descriptor (metadata/install.xml) could not be created/saved properly.", e);
            throw subEx;
        }
    }

    public static String addMacro(String s) {
        String macro = "$main_root";
        if (s == null || ((String)s).length() == 0) {
            return "";
        }
        s = ((String)s).startsWith("/") || ((String)s).startsWith("\\") ? macro + (String)s : macro + File.separator + (String)s;
        return s;
    }
}

