/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Min;
import java.math.BigDecimal;

public class MinValidatorForString
implements ConstraintValidator<Min, String> {
    private long minValue;

    public void initialize(Min annotation) {
        this.minValue = annotation.value();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(BigDecimal.valueOf(this.minValue)) >= 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

