/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Map;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.ResourceEnvRef;

public class BuiltInEnvironmentEntries
implements DynamicDeployer {
    private final boolean addDefaults;

    public BuiltInEnvironmentEntries(boolean addDefaults) {
        this.addDefaults = addDefaults;
    }

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        ApplicationClient consumer;
        for (ClientModule clientModule : appModule.getClientModules()) {
            consumer = clientModule.getApplicationClient();
            if (consumer == null) continue;
            this.add((JndiConsumer)consumer, clientModule, appModule, false);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            this.add((JndiConsumer)consumer, webModule, appModule, this.addDefaults);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            if (ejbJar == null) continue;
            for (EnterpriseBean consumer2 : ejbJar.getEnterpriseBeans()) {
                this.add((JndiConsumer)consumer2, ejbModule, appModule, this.addDefaults && BeanContext.Comp.class.getName().equals(consumer2.getEjbClass()));
            }
        }
        return appModule;
    }

    private void add(JndiConsumer jndi, DeploymentModule module, DeploymentModule app, boolean defaults) {
        this.add(jndi.getEnvEntryMap(), new EnvEntry().name("java:module/ModuleName").value(module.getModuleId()).type(String.class));
        this.add(jndi.getEnvEntryMap(), new EnvEntry().name("java:app/AppName").value(app.getModuleId()).type(String.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/BeanManager").type(BeanManager.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/Validator").type(Validator.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/ValidatorFactory").type(ValidatorFactory.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/TransactionManager").type(TransactionManager.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/TransactionSynchronizationRegistry").type(TransactionSynchronizationRegistry.class));
        if (defaults) {
            this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/DefaultManagedExecutorService").type(ManagedExecutorService.class));
            this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/DefaultManagedScheduledExecutorService").type(ManagedScheduledExecutorService.class));
            this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/DefaultManagedThreadFactory").type(ManagedThreadFactory.class));
            this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/DefaultContextService").type(ContextService.class));
            try {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                contextClassLoader.loadClass("org.apache.activemq.ActiveMQSslConnectionFactory");
                ResourceEnvRef ref = new ResourceEnvRef().name("java:comp/DefaultJMSConnectionFactory").type(contextClassLoader.loadClass("jakarta.jms.ConnectionFactory"));
                this.add(jndi.getResourceEnvRefMap(), ref);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        this.add(jndi.getEnvEntryMap(), new EnvEntry().name("java:comp/ComponentName").value(jndi.getJndiConsumerName()).type(String.class));
    }

    private <E extends JndiReference> void add(Map<String, E> map, E entry) {
        JndiReference existing = (JndiReference)map.get(entry.getKey());
        map.put((String)entry.getKey(), entry);
        if (existing != null) {
            entry.getInjectionTarget().addAll(existing.getInjectionTarget());
        }
    }
}

