/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlFormRendererBase
extends HtmlRenderer {
    private static final String FORM_TARGET = "form";
    private static final String HIDDEN_SUBMIT_INPUT_SUFFIX = "_SUBMIT";
    private static final String HIDDEN_SUBMIT_INPUT_VALUE = "1";
    private static final String SCROLL_HIDDEN_INPUT = "org.apache.myfaces.SCROLL_HIDDEN_INPUT";
    private static final String SHARED_STRING_BUILDER = HtmlFormRendererBase.class.getName() + ".SHARED_STRING_BUILDER";
    private MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance();

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, UIForm.class);
        UIForm htmlForm = (UIForm)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = htmlForm.getClientId(facesContext);
        String acceptCharset = this.getAcceptCharset(facesContext, htmlForm);
        String actionURL = this.getActionUrl(facesContext, htmlForm);
        String method = this.getMethod(facesContext, htmlForm);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement(FORM_TARGET, (UIComponent)htmlForm);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("method", (Object)method, null);
        if (acceptCharset != null) {
            writer.writeAttribute("accept-charset", (Object)acceptCharset, null);
        }
        String encodedActionURL = facesContext.getExternalContext().encodeActionURL(actionURL);
        writer.writeURIAttribute("action", (Object)encodedActionURL, null);
        if (htmlForm instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)htmlForm).getClientBehaviors();
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderEventProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes((UIComponent)htmlForm), (UIComponent)htmlForm);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, CommonHtmlAttributesUtil.getMarkedAttributes((UIComponent)htmlForm), CommonHtmlEventsUtil.getMarkedEvents((UIComponent)htmlForm), (UIComponent)htmlForm, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)htmlForm, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonHtmlAttributesUtil.getMarkedAttributes(component), component);
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)htmlForm, HTML.FORM_ATTRIBUTES);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)htmlForm, HTML.FORM_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonHtmlAttributesUtil.renderCommonPassthroughProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes(component), component);
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)htmlForm, HTML.FORM_ATTRIBUTES);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)htmlForm, HTML.FORM_PASSTHROUGH_ATTRIBUTES);
        }
        writer.write("");
        String encodedPartialActionURL = facesContext.getExternalContext().encodePartialActionURL(actionURL);
        if (encodedActionURL != null && encodedPartialActionURL != null && !encodedActionURL.equals(encodedPartialActionURL)) {
            HtmlRendererUtils.renderHiddenInputField(writer, "jakarta.faces.encodedURL", encodedPartialActionURL);
        }
        this.beforeFormElementsStart(facesContext, component);
        if (this.myfacesConfig.isRenderFormViewStateAtBegin()) {
            this.renderViewStateAndHiddenFields(facesContext, component);
        }
        this.afterFormElementsStart(facesContext, component);
    }

    protected String getActionUrl(FacesContext facesContext, UIForm form) {
        return this.getActionUrl(facesContext);
    }

    protected String getMethod(FacesContext facesContext, UIForm form) {
        return "post";
    }

    protected String getAcceptCharset(FacesContext facesContext, UIForm form) {
        return (String)form.getAttributes().get("acceptcharset");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeFormElementsEnd(facesContext, component);
        if (!this.myfacesConfig.isRenderFormViewStateAtBegin()) {
            this.renderViewStateAndHiddenFields(facesContext, component);
        }
        this.afterFormElementsEnd(facesContext, component);
        writer.endElement(FORM_TARGET);
    }

    protected void renderViewStateAndHiddenFields(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        StringBuilder sb = SharedStringBuilder.get((FacesContext)facesContext, (String)SHARED_STRING_BUILDER);
        writer.writeAttribute("name", (Object)sb.append(component.getClientId(facesContext)).append(HIDDEN_SUBMIT_INPUT_SUFFIX).toString(), null);
        writer.writeAttribute("value", (Object)HIDDEN_SUBMIT_INPUT_VALUE, null);
        writer.endElement("input");
        HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(component, facesContext, writer);
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        viewHandler.writeState(facesContext);
        List componentResources = facesContext.getViewRoot().getComponentResources(facesContext, FORM_TARGET);
        int size = componentResources.size();
        for (int i = 0; i < size; ++i) {
            UIComponent child = (UIComponent)componentResources.get(i);
            child.encodeAll(facesContext);
        }
    }

    private static String getScrollHiddenInputName(FacesContext facesContext, UIComponent form) {
        StringBuilder sb = SharedStringBuilder.get((FacesContext)facesContext, (String)SHARED_STRING_BUILDER, (int)(SCROLL_HIDDEN_INPUT.length() + 20));
        sb.append(SCROLL_HIDDEN_INPUT);
        sb.append('_');
        sb.append(form.getClientId(facesContext));
        return sb.toString();
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, UIForm.class);
        UIForm htmlForm = (UIForm)component;
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        StringBuilder sb = SharedStringBuilder.get((FacesContext)facesContext, (String)SHARED_STRING_BUILDER, (int)100);
        String submittedValue = (String)paramMap.get(sb.append(component.getClientId(facesContext)).append(HIDDEN_SUBMIT_INPUT_SUFFIX));
        if (submittedValue != null && submittedValue.equals(HIDDEN_SUBMIT_INPUT_VALUE)) {
            htmlForm.setSubmitted(true);
        } else {
            htmlForm.setSubmitted(false);
        }
        ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
    }

    public static void renderScrollHiddenInputIfNecessary(UIComponent form, FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (form == null) {
            return;
        }
        if (facesContext.getExternalContext().getRequestMap().get(HtmlFormRendererBase.getScrollHiddenInputName(facesContext, form)) == null) {
            facesContext.getExternalContext().getRequestMap().put(HtmlFormRendererBase.getScrollHiddenInputName(facesContext, form), Boolean.TRUE);
        }
    }

    protected void beforeFormElementsStart(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected void afterFormElementsStart(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected void beforeFormElementsEnd(FacesContext facesContext, UIComponent component) throws IOException {
    }

    protected void afterFormElementsEnd(FacesContext facesContext, UIComponent component) throws IOException {
    }
}

