/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.deployment;

import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.AnnotationUtil;

public class StereoTypeModel
implements IStereoTypeModel {
    private String name;
    private Annotation defaultDeploymentType;
    private Annotation defaultScopeType;
    private Set<Annotation> interceptorBindingTypes = new HashSet<Annotation>();
    private Set<Annotation> inherits = new HashSet<Annotation>();
    private static final Logger logger = WebBeansLoggerFacade.getLogger(StereoTypeModel.class);
    private boolean named;

    public StereoTypeModel(WebBeansContext webBeansContext, Class<? extends Annotation> clazz) {
        this(webBeansContext, clazz, clazz.getDeclaredAnnotations());
    }

    public StereoTypeModel(WebBeansContext webBeansContext, Class<? extends Annotation> clazz, Annotation[] annotationDefs) {
        this.name = clazz.getName();
        this.configAnnotations(clazz, webBeansContext, annotationDefs);
    }

    private void configAnnotations(Class<? extends Annotation> clazz, WebBeansContext webBeansContext, Annotation ... annotations) {
        AnnotationManager annotationManager;
        Annotation[] qualifiers;
        if (clazz.getAnnotation(Typed.class) != null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0016", clazz.getName());
        }
        if ((qualifiers = (annotationManager = webBeansContext.getAnnotationManager()).getQualifierAnnotations(annotations)) != null) {
            for (Annotation qualifier : qualifiers) {
                if (qualifier.annotationType() == Default.class) {
                    return;
                }
                if (qualifier.annotationType() != Named.class) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "WARN_0017", WebBeansLoggerFacade.args(clazz.getName(), qualifier.annotationType().getName()));
                    continue;
                }
                if (this.named) continue;
                this.named = true;
            }
        }
        if (AnnotationUtil.hasMetaAnnotation(annotations, NormalScope.class)) {
            this.defaultScopeType = AnnotationUtil.getMetaAnnotations(annotations, NormalScope.class)[0];
        }
        if (AnnotationUtil.hasMetaAnnotation(annotations, Scope.class)) {
            this.defaultScopeType = AnnotationUtil.getMetaAnnotations(annotations, Scope.class)[0];
        }
        if (annotationManager.hasInterceptorBindingMetaAnnotation(annotations)) {
            Annotation[] ibs;
            for (Annotation ann : ibs = annotationManager.getInterceptorBindingMetaAnnotations(annotations)) {
                this.interceptorBindingTypes.add(ann);
            }
        }
        if (annotationManager.hasStereoTypeMetaAnnotation(annotations)) {
            Annotation[] isy = annotationManager.getStereotypeMetaAnnotations(annotations);
            Target outerStereo = clazz.getAnnotation(Target.class);
            for (Annotation is : isy) {
                Target innerStereo = is.annotationType().getAnnotation(Target.class);
                ElementType[] innerValues = innerStereo.value();
                ElementType[] outerValues = outerStereo.value();
                for (ElementType innerValue : innerValues) {
                    if (innerValue == ElementType.METHOD || innerValue == ElementType.FIELD) {
                        for (ElementType outerValue : outerValues) {
                            if (outerValue != ElementType.TYPE || outerValues.length != 1) continue;
                            throw new WebBeansConfigurationException("Inherited StereoType with class name : " + clazz.getName() + " must have compatible @Target annotation with Stereotype class name : " + clazz.getName());
                        }
                        continue;
                    }
                    if (innerValue != ElementType.TYPE || innerValues.length != 1) continue;
                    for (ElementType outerValue : outerValues) {
                        if (outerValue != ElementType.METHOD && outerValue != ElementType.FIELD) continue;
                        throw new WebBeansConfigurationException("Inherited StereoType with class name : " + clazz.getName() + " must have compatible @Target annotation with Stereotype class name : " + clazz.getName());
                    }
                }
                this.inherits.add(is);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Annotation getDefaultDeploymentType() {
        return this.defaultDeploymentType;
    }

    @Override
    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    @Override
    public Set<Annotation> getInterceptorBindingTypes() {
        return this.interceptorBindingTypes;
    }

    @Override
    public Set<Annotation> getInheritedStereoTypes() {
        return this.inherits;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StereoTypeModel)) {
            return false;
        }
        StereoTypeModel model = (StereoTypeModel)obj;
        return model.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isNamed() {
        return this.named;
    }
}

