/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayEntityManager;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.ExecutionQueryImpl;
import org.flowable.engine.impl.ProcessInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmmn.CaseInstanceService;
import org.flowable.engine.impl.delegate.InterruptibleActivityBehaviour;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.data.ExecutionDataManager;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.api.EntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.cachematcher.IdentityLinksByProcessInstanceMatcher;
import org.flowable.job.service.JobService;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEntityManagerImpl
extends AbstractProcessEngineEntityManager<ExecutionEntity, ExecutionDataManager>
implements ExecutionEntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionEntityManagerImpl.class);
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinkByProcessInstanceMatcher = new IdentityLinksByProcessInstanceMatcher();

    public ExecutionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionDataManager executionDataManager) {
        super(processEngineConfiguration, executionDataManager);
    }

    public void delete(ExecutionEntity entity) {
        this.delete(entity, true);
    }

    public void delete(ExecutionEntity entity, boolean fireDeleteEvent) {
        super.delete((Entity)entity, fireDeleteEvent);
        entity.setDeleted(true);
    }

    @Override
    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return ((ExecutionDataManager)this.dataManager).findSubProcessInstanceBySuperExecutionId(superExecutionId);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return ((ExecutionDataManager)this.dataManager).findChildExecutionsByParentExecutionId(parentExecutionId);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return ((ExecutionDataManager)this.dataManager).findChildExecutionsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByParentExecutionAndActivityIds(String parentExecutionId, Collection<String> activityIds) {
        return ((ExecutionDataManager)this.dataManager).findExecutionsByParentExecutionAndActivityIds(parentExecutionId, activityIds);
    }

    @Override
    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return ((ExecutionDataManager)this.dataManager).findExecutionCountByQueryCriteria(executionQuery);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return ((ExecutionDataManager)this.dataManager).findExecutionsByQueryCriteria(executionQuery);
    }

    @Override
    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return ((ExecutionDataManager)this.dataManager).findProcessInstanceCountByQueryCriteria(executionQuery);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return ((ExecutionDataManager)this.dataManager).findProcessInstanceByQueryCriteria(executionQuery);
    }

    @Override
    public ExecutionEntity findByRootProcessInstanceId(String rootProcessInstanceId) {
        List<ExecutionEntity> executions = ((ExecutionDataManager)this.dataManager).findExecutionsByRootProcessInstanceId(rootProcessInstanceId);
        return this.processExecutionTree(rootProcessInstanceId, executions);
    }

    protected ExecutionEntity processExecutionTree(String rootProcessInstanceId, List<ExecutionEntity> executions) {
        ExecutionEntity rootExecution = null;
        HashMap<String, ExecutionEntity> executionMap = new HashMap<String, ExecutionEntity>(executions.size());
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getId().equals(rootProcessInstanceId)) {
                rootExecution = executionEntity;
            }
            executionMap.put(executionEntity.getId(), executionEntity);
        }
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getRootProcessInstanceId() != null) {
                executionEntity.setRootProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getRootProcessInstanceId()));
            }
            if (executionEntity.getProcessInstanceId() != null) {
                executionEntity.setProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getProcessInstanceId()));
            }
            if (executionEntity.getParentId() != null) {
                ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getParentId());
                executionEntity.setParent(parentExecutionEntity);
                parentExecutionEntity.addChildExecution(executionEntity);
            }
            if (executionEntity.getSuperExecution() == null) continue;
            ExecutionEntity superExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getSuperExecutionId());
            executionEntity.setSuperExecution(superExecutionEntity);
            superExecutionEntity.setSubProcessInstance(executionEntity);
        }
        return rootExecution;
    }

    @Override
    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return ((ExecutionDataManager)this.dataManager).findProcessInstanceAndVariablesByQueryCriteria(executionQuery);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByProcessInstanceId(String processInstanceId) {
        return ((ExecutionDataManager)this.dataManager).findInactiveExecutionsByProcessInstanceId(processInstanceId);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityIdAndProcessInstanceId(String activityId, String processInstanceId) {
        return ((ExecutionDataManager)this.dataManager).findInactiveExecutionsByActivityIdAndProcessInstanceId(activityId, processInstanceId);
    }

    @Override
    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap) {
        return ((ExecutionDataManager)this.dataManager).findExecutionsByNativeQuery(parameterMap);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap) {
        return ((ExecutionDataManager)this.dataManager).findProcessInstanceByNativeQuery(parameterMap);
    }

    @Override
    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((ExecutionDataManager)this.dataManager).findExecutionCountByNativeQuery(parameterMap);
    }

    @Override
    public long countActiveExecutionsByParentId(String parentId) {
        return ((ExecutionDataManager)this.dataManager).countActiveExecutionsByParentId(parentId);
    }

    @Override
    public ExecutionEntity createProcessInstanceExecution(ProcessDefinition processDefinition, String predefinedProcessInstanceId, String businessKey, String businessStatus, String processInstanceName, String callbackId, String callbackType, String referenceId, String referenceType, String propagatedStageInstanceId, String tenantId, String initiatorVariableName, String startActivityId) {
        ExecutionEntity processInstanceExecution = (ExecutionEntity)((ExecutionDataManager)this.dataManager).create();
        if (CountingEntityUtil.isExecutionRelatedEntityCountEnabledGlobally()) {
            ((CountingExecutionEntity)((Object)processInstanceExecution)).setCountEnabled(true);
        }
        if (predefinedProcessInstanceId != null) {
            processInstanceExecution.setId(predefinedProcessInstanceId);
        }
        processInstanceExecution.setProcessDefinitionId(processDefinition.getId());
        processInstanceExecution.setProcessDefinitionKey(processDefinition.getKey());
        processInstanceExecution.setProcessDefinitionName(processDefinition.getName());
        processInstanceExecution.setProcessDefinitionVersion(processDefinition.getVersion());
        processInstanceExecution.setDeploymentId(processDefinition.getDeploymentId());
        processInstanceExecution.setBusinessKey(businessKey);
        processInstanceExecution.setBusinessStatus(businessStatus);
        processInstanceExecution.setName(processInstanceName);
        if (callbackId != null) {
            processInstanceExecution.setCallbackId(callbackId);
        }
        if (callbackType != null) {
            processInstanceExecution.setCallbackType(callbackType);
        }
        if (referenceId != null) {
            processInstanceExecution.setReferenceId(referenceId);
        }
        if (referenceType != null) {
            processInstanceExecution.setReferenceType(referenceType);
        }
        if (propagatedStageInstanceId != null) {
            processInstanceExecution.setPropagatedStageInstanceId(propagatedStageInstanceId);
        }
        processInstanceExecution.setScope(true);
        if (tenantId != null) {
            processInstanceExecution.setTenantId(tenantId);
        }
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        processInstanceExecution.setStartActivityId(startActivityId);
        processInstanceExecution.setStartTime(CommandContextUtil.getProcessEngineConfiguration().getClock().getCurrentTime());
        processInstanceExecution.setStartUserId(authenticatedUserId);
        this.insert(processInstanceExecution, false);
        if (initiatorVariableName != null) {
            processInstanceExecution.setVariable(initiatorVariableName, authenticatedUserId);
        }
        processInstanceExecution.setProcessInstanceId(processInstanceExecution.getId());
        processInstanceExecution.setRootProcessInstanceId(processInstanceExecution.getId());
        if (((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkInterceptor() != null) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkInterceptor().handleCreateProcessInstance(processInstanceExecution);
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, processInstanceExecution), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        return processInstanceExecution;
    }

    @Override
    public ExecutionEntity createChildExecution(ExecutionEntity parentExecutionEntity) {
        ExecutionEntity childExecution = (ExecutionEntity)((ExecutionDataManager)this.dataManager).create();
        this.inheritCommonProperties(parentExecutionEntity, childExecution);
        childExecution.setParent(parentExecutionEntity);
        childExecution.setProcessDefinitionId(parentExecutionEntity.getProcessDefinitionId());
        childExecution.setProcessDefinitionKey(parentExecutionEntity.getProcessDefinitionKey());
        childExecution.setProcessInstanceId(parentExecutionEntity.getProcessInstanceId() != null ? parentExecutionEntity.getProcessInstanceId() : parentExecutionEntity.getId());
        childExecution.setScope(false);
        parentExecutionEntity.addChildExecution(childExecution);
        this.insert(childExecution, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Child execution {} created with parent {}", (Object)childExecution, (Object)parentExecutionEntity.getId());
        }
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, childExecution), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, childExecution), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        return childExecution;
    }

    @Override
    public ExecutionEntity createSubprocessInstance(ProcessDefinition processDefinition, ExecutionEntity superExecutionEntity, String businessKey, String activityId) {
        ExecutionEntity subProcessInstance = (ExecutionEntity)((ExecutionDataManager)this.dataManager).create();
        this.inheritCommonProperties(superExecutionEntity, subProcessInstance);
        subProcessInstance.setProcessDefinitionId(processDefinition.getId());
        subProcessInstance.setProcessDefinitionKey(processDefinition.getKey());
        subProcessInstance.setProcessDefinitionName(processDefinition.getName());
        subProcessInstance.setSuperExecution(superExecutionEntity);
        subProcessInstance.setRootProcessInstanceId(superExecutionEntity.getRootProcessInstanceId());
        subProcessInstance.setScope(true);
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        subProcessInstance.setStartActivityId(activityId);
        subProcessInstance.setStartUserId(authenticatedUserId);
        subProcessInstance.setBusinessKey(businessKey);
        this.insert(subProcessInstance, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Child execution {} created with super execution {}", (Object)subProcessInstance, (Object)superExecutionEntity.getId());
        }
        subProcessInstance.setProcessInstanceId(subProcessInstance.getId());
        superExecutionEntity.setSubProcessInstance(subProcessInstance);
        if (((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkInterceptor() != null) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkInterceptor().handleCreateSubProcessInstance(subProcessInstance, superExecutionEntity);
        }
        ((ProcessEngineConfigurationImpl)this.engineConfiguration).getProcessInstanceHelper().processAvailableEventSubProcesses(subProcessInstance, (FlowElementsContainer)ProcessDefinitionUtil.getProcess(processDefinition.getId()), CommandContextUtil.getCommandContext());
        FlowableEventDispatcher flowableEventDispatcher = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventDispatcher();
        if (flowableEventDispatcher != null && flowableEventDispatcher.isEnabled()) {
            flowableEventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, subProcessInstance), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        return subProcessInstance;
    }

    protected void inheritCommonProperties(ExecutionEntity parentExecutionEntity, ExecutionEntity childExecution) {
        if (parentExecutionEntity instanceof CountingExecutionEntity) {
            CountingExecutionEntity countingParentExecutionEntity = (CountingExecutionEntity)((Object)parentExecutionEntity);
            ((CountingExecutionEntity)((Object)childExecution)).setCountEnabled(countingParentExecutionEntity.isCountEnabled());
        }
        childExecution.setPropagatedStageInstanceId(parentExecutionEntity.getPropagatedStageInstanceId());
        childExecution.setRootProcessInstanceId(parentExecutionEntity.getRootProcessInstanceId());
        childExecution.setActive(true);
        childExecution.setStartTime(this.getClock().getCurrentTime());
        if (parentExecutionEntity.getTenantId() != null) {
            childExecution.setTenantId(parentExecutionEntity.getTenantId());
        }
    }

    @Override
    public void updateExecutionTenantIdForDeployment(String deploymentId, String newTenantId) {
        ((ExecutionDataManager)this.dataManager).updateExecutionTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List<String> processInstanceIds = ((ExecutionDataManager)this.dataManager).findProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstanceCascade((ExecutionEntity)this.findById(processInstanceId), deleteReason, cascade, true);
        }
        if (cascade) {
            this.getHistoryManager().recordDeleteHistoricProcessInstancesByProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        this.deleteProcessInstance(processInstanceId, deleteReason, cascade, false);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade, boolean directDeleteInDatabase) {
        ExecutionEntity superExecution;
        ExecutionEntity processInstanceExecution = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceExecution == null) {
            throw new FlowableObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        this.deleteProcessInstanceCascade(processInstanceExecution, deleteReason, cascade, directDeleteInDatabase);
        if (processInstanceExecution.getSuperExecutionId() != null && (superExecution = processInstanceExecution.getSuperExecution()) != null && superExecution.getCurrentFlowElement() instanceof FlowNode && ((FlowNode)superExecution.getCurrentFlowElement()).getBehavior() instanceof SubProcessActivityBehavior) {
            SubProcessActivityBehavior subProcessActivityBehavior = (SubProcessActivityBehavior)((FlowNode)superExecution.getCurrentFlowElement()).getBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, processInstanceExecution);
                superExecution.setSubProcessInstance(null);
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (Exception e) {
                throw new FlowableException("Could not complete parent process instance for call activity with process instance execution " + processInstanceExecution.getId(), (Throwable)e);
            }
        }
    }

    protected void deleteProcessInstanceCascade(ExecutionEntity execution, String deleteReason, boolean deleteHistory, boolean directDeleteInDatabase) {
        ExecutionEntity processInstanceExecutionEntity;
        if (deleteReason == null) {
            deleteReason = "process instance deleted";
        }
        this.getActivityInstanceEntityManager().deleteActivityInstancesByProcessInstanceId(execution.getId());
        List<ExecutionEntity> childExecutions = this.collectChildren(execution.getProcessInstance());
        for (ExecutionEntity subExecutionEntity : childExecutions) {
            Iterator<? extends ExecutionEntity> behavior;
            FlowElement subExecutionFlowElement = subExecutionEntity.getCurrentFlowElement();
            if (subExecutionFlowElement instanceof FlowNode && (behavior = ((FlowNode)subExecutionFlowElement).getBehavior()) instanceof InterruptibleActivityBehaviour) {
                ((InterruptibleActivityBehaviour)((Object)behavior)).interrupted(subExecutionEntity);
            }
            if (subExecutionEntity.isMultiInstanceRoot()) {
                behavior = subExecutionEntity.getExecutions().iterator();
                while (behavior.hasNext()) {
                    ExecutionEntity miExecutionEntity = behavior.next();
                    if (miExecutionEntity.getSubProcessInstance() == null) continue;
                    this.deleteProcessInstanceCascade(miExecutionEntity.getSubProcessInstance(), deleteReason, deleteHistory, directDeleteInDatabase);
                    if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled()) continue;
                    FlowElement callActivityElement = miExecutionEntity.getCurrentFlowElement();
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(callActivityElement.getId(), callActivityElement.getName(), miExecutionEntity.getId(), miExecutionEntity.getProcessInstanceId(), miExecutionEntity.getProcessDefinitionId(), "callActivity", deleteReason), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                }
                continue;
            }
            if (subExecutionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(subExecutionEntity.getSubProcessInstance(), deleteReason, deleteHistory, directDeleteInDatabase);
            if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled()) continue;
            FlowElement callActivityElement = subExecutionEntity.getCurrentFlowElement();
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(callActivityElement.getId(), callActivityElement.getName(), subExecutionEntity.getId(), subExecutionEntity.getProcessInstanceId(), subExecutionEntity.getProcessDefinitionId(), "callActivity", deleteReason), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        TaskHelper.deleteTasksByProcessInstanceId(execution.getId(), deleteReason, deleteHistory);
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createCancelledEvent(execution.getProcessInstanceId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), deleteReason), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        if ((processInstanceExecutionEntity = execution.getProcessInstance()) == null) {
            return;
        }
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            ExecutionEntity childExecutionEntity = childExecutions.get(i);
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, deleteHistory, directDeleteInDatabase);
        }
        this.deleteExecutionAndRelatedData(execution, deleteReason, deleteHistory, directDeleteInDatabase, true, null);
        if (deleteHistory) {
            this.getHistoryManager().recordProcessInstanceDeleted(execution.getId(), execution.getProcessDefinitionId(), execution.getTenantId());
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceExecutionEntity, deleteReason, null, this.getClock().getCurrentTime());
        processInstanceExecutionEntity.setDeleted(true);
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean deleteHistory, boolean directDeleteInDatabase, boolean cancel, FlowElement cancelActivity) {
        if (!deleteHistory && executionEntity.isActive() && executionEntity.getCurrentFlowElement() != null && !executionEntity.isMultiInstanceRoot()) {
            CommandContextUtil.getActivityInstanceEntityManager().recordActivityEnd(executionEntity, deleteReason);
        }
        this.deleteRelatedDataForExecution(executionEntity, deleteReason, directDeleteInDatabase);
        this.delete(executionEntity);
        if (cancel && !executionEntity.isProcessInstanceType()) {
            this.dispatchActivityCancelled(executionEntity, cancelActivity != null ? cancelActivity : executionEntity.getCurrentFlowElement());
        }
        if (executionEntity.isProcessInstanceType() && executionEntity.getCallbackId() != null) {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessInstanceHelper(commandContext);
            if (cancel) {
                processInstanceHelper.callCaseInstanceStateChangeCallbacks(commandContext, executionEntity, "running", "cancelled");
            } else {
                processInstanceHelper.callCaseInstanceStateChangeCallbacks(commandContext, executionEntity, "running", "completed");
            }
        }
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean deleteHistory) {
        this.deleteExecutionAndRelatedData(executionEntity, deleteReason, deleteHistory, false, false, null);
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean deleteHistory, boolean directDeleteInDatabase) {
        this.deleteExecutionAndRelatedData(executionEntity, deleteReason, deleteHistory, directDeleteInDatabase, false, null);
    }

    @Override
    public void deleteProcessInstanceExecutionEntity(String processInstanceId, String currentFlowElementId, String deleteReason, boolean cascade, boolean cancel, boolean fireEvents) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        if (processInstanceEntity.isDeleted()) {
            return;
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (executionEntity.getSubProcessInstance() == null || executionEntity.isEnded()) continue;
            this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, cascade, false);
            if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled() || !fireEvents) continue;
            FlowElement callActivityElement = executionEntity.getCurrentFlowElement();
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(callActivityElement.getId(), callActivityElement.getName(), executionEntity.getId(), processInstanceId, executionEntity.getProcessDefinitionId(), "callActivity", deleteReason), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (!executionEntity.isEventScope()) continue;
            this.deleteExecutionAndRelatedData(executionEntity, null, cascade, false);
        }
        this.deleteChildExecutions(processInstanceEntity, deleteReason, cancel);
        this.deleteExecutionAndRelatedData(processInstanceEntity, deleteReason, cascade, false);
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled() && fireEvents) {
            if (!cancel) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_COMPLETED, processInstanceEntity), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            } else {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createCancelledEvent(processInstanceEntity.getId(), processInstanceEntity.getId(), processInstanceEntity.getProcessDefinitionId(), deleteReason), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            }
        }
        if (((ProcessEngineConfigurationImpl)this.engineConfiguration).isLoggingSessionEnabled()) {
            BpmnLoggingSessionUtil.addLoggingData("processCompleted", "Completed process instance with id " + processInstanceEntity.getId(), processInstanceEntity);
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceEntity, deleteReason, currentFlowElementId, this.getClock().getCurrentTime());
        processInstanceEntity.setDeleted(true);
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        this.deleteChildExecutions(executionEntity, null, null, deleteReason, cancel, null);
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, Collection<String> executionIdsNotToDelete, Collection<String> executionIdsNotToSendCancelledEventFor, String deleteReason, boolean cancel, FlowElement cancelActivity) {
        List<ExecutionEntity> childExecutions = this.collectChildren(executionEntity, executionIdsNotToDelete);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            ExecutionEntity childExecutionEntity = childExecutions.get(i);
            if (childExecutionEntity.isEnded() || executionIdsNotToDelete != null && executionIdsNotToDelete.contains(childExecutionEntity.getId())) continue;
            if (childExecutionEntity.isProcessInstanceType()) {
                this.deleteProcessInstanceExecutionEntity(childExecutionEntity.getId(), cancelActivity != null ? cancelActivity.getId() : null, deleteReason, true, cancel, true);
            } else if (cancel && (childExecutionEntity.isActive() || childExecutionEntity.isMultiInstanceRoot()) && (executionIdsNotToSendCancelledEventFor == null || !executionIdsNotToSendCancelledEventFor.contains(childExecutionEntity.getId()))) {
                this.dispatchExecutionCancelled(childExecutionEntity, cancelActivity != null ? cancelActivity : childExecutionEntity.getCurrentFlowElement());
            }
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, false, false);
        }
    }

    @Override
    public List<ExecutionEntity> collectChildren(ExecutionEntity executionEntity) {
        return this.collectChildren(executionEntity, null);
    }

    protected List<ExecutionEntity> collectChildren(ExecutionEntity executionEntity, Collection<String> executionIdsToExclude) {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        this.collectChildren(executionEntity, childExecutions, executionIdsToExclude != null ? executionIdsToExclude : Collections.emptyList());
        return childExecutions;
    }

    protected void collectChildren(ExecutionEntity executionEntity, List<ExecutionEntity> collectedChildExecution, Collection<String> executionIdsToExclude) {
        ExecutionEntity subProcessInstance;
        List<? extends ExecutionEntity> childExecutions = executionEntity.getExecutions();
        if (childExecutions != null && childExecutions.size() > 0) {
            childExecutions.sort(ExecutionEntity.EXECUTION_ENTITY_START_TIME_ASC_COMPARATOR);
            for (ExecutionEntity executionEntity2 : childExecutions) {
                if (executionIdsToExclude.contains(executionEntity2.getId())) continue;
                if (!executionEntity2.isDeleted()) {
                    collectedChildExecution.add(executionEntity2);
                }
                this.collectChildren(executionEntity2, collectedChildExecution, executionIdsToExclude);
            }
        }
        if ((subProcessInstance = executionEntity.getSubProcessInstance()) != null && !executionIdsToExclude.contains(subProcessInstance.getId())) {
            if (!subProcessInstance.isDeleted()) {
                collectedChildExecution.add(subProcessInstance);
            }
            this.collectChildren(subProcessInstance, collectedChildExecution, executionIdsToExclude);
        }
    }

    protected void dispatchExecutionCancelled(ExecutionEntity execution, FlowElement cancelActivity) {
        FlowElement currentFlowElement;
        ExecutionEntityManager executionEntityManager = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getExecutionEntityManager();
        for (ExecutionEntity subExecution : executionEntityManager.findChildExecutionsByParentExecutionId(execution.getId())) {
            this.dispatchExecutionCancelled(subExecution, cancelActivity);
        }
        ExecutionEntity subProcessInstance = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, cancelActivity);
        }
        if ((currentFlowElement = execution.getCurrentFlowElement()) instanceof FlowNode) {
            if (execution.isMultiInstanceRoot()) {
                this.dispatchMultiInstanceActivityCancelled(execution, cancelActivity);
            } else {
                this.dispatchActivityCancelled(execution, cancelActivity);
            }
        }
    }

    protected void dispatchActivityCancelled(ExecutionEntity execution, FlowElement cancelActivity) {
        FlowableEventDispatcher eventDispatcher = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.getActivityType(execution.getCurrentFlowElement()), cancelActivity), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
    }

    protected void dispatchMultiInstanceActivityCancelled(ExecutionEntity execution, FlowElement cancelActivity) {
        FlowableEventDispatcher eventDispatcher = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createMultiInstanceActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.getActivityType(execution.getCurrentFlowElement()), cancelActivity), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
    }

    protected String getActivityType(FlowElement flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }

    @Override
    public ExecutionEntity findFirstScope(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isScope()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public ExecutionEntity findFirstMultiInstanceRoot(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isMultiInstanceRoot()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public void deleteRelatedDataForExecution(ExecutionEntity executionEntity, String deleteReason, boolean directDeleteInDatabase) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ending and deleting execution {} Reason: {}", (Object)executionEntity, (Object)deleteReason);
        }
        executionEntity.setEnded(true);
        executionEntity.setActive(false);
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        boolean enableExecutionRelationshipCounts = CountingEntityUtil.isExecutionRelatedEntityCountEnabled(executionEntity);
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher();
        boolean eventDispatcherEnabled = eventDispatcher != null && eventDispatcher.isEnabled();
        this.deleteIdentityLinks(executionEntity, commandContext, eventDispatcherEnabled);
        this.deleteEntityLinks(executionEntity, commandContext, eventDispatcherEnabled);
        this.deleteVariables(executionEntity, commandContext, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteUserTasks(executionEntity, deleteReason, commandContext, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteJobs(executionEntity, commandContext, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteEventSubScriptions(executionEntity, enableExecutionRelationshipCounts, eventDispatcherEnabled);
        this.deleteActivityInstances(executionEntity, commandContext);
        this.deleteSubCases(executionEntity, directDeleteInDatabase, commandContext);
    }

    protected void deleteSubCases(ExecutionEntity executionEntity, boolean directDeleteInDatabase, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        CaseInstanceService caseInstanceService = processEngineConfiguration.getCaseInstanceService();
        if (caseInstanceService != null) {
            if (executionEntity.getReferenceId() != null && "bpmn-2.0-to-cmmn-1.1-child-case".equals(executionEntity.getReferenceType())) {
                if (directDeleteInDatabase) {
                    caseInstanceService.deleteCaseInstanceWithoutAgenda(executionEntity.getReferenceId());
                } else {
                    caseInstanceService.deleteCaseInstance(executionEntity.getReferenceId());
                }
            } else if (executionEntity.getCurrentFlowElement() instanceof CaseServiceTask) {
                caseInstanceService.deleteCaseInstancesForExecutionId(executionEntity.getId());
            }
        }
    }

    protected void deleteActivityInstances(ExecutionEntity executionEntity, CommandContext commandContext) {
        if (executionEntity.isProcessInstanceType()) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getActivityInstanceEntityManager().deleteActivityInstancesByProcessInstanceId(executionEntity.getId());
        }
    }

    protected void deleteIdentityLinks(ExecutionEntity executionEntity, CommandContext commandContext, boolean eventDispatcherEnabled) {
        if (executionEntity.isProcessInstanceType()) {
            IdentityLinkService identityLinkService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkService();
            boolean deleteIdentityLinks = true;
            if (eventDispatcherEnabled) {
                List identityLinks = identityLinkService.findIdentityLinksByProcessInstanceId(executionEntity.getId());
                for (IdentityLinkEntity identityLink : identityLinks) {
                    this.fireEntityDeletedEvent((Entity)identityLink);
                }
                boolean bl = deleteIdentityLinks = !identityLinks.isEmpty();
            }
            if (deleteIdentityLinks) {
                identityLinkService.deleteIdentityLinksByProcessInstanceId(executionEntity.getId());
            }
        }
    }

    protected void deleteEntityLinks(ExecutionEntity executionEntity, CommandContext commandContext, boolean eventDispatcherEnabled) {
        if (((ProcessEngineConfigurationImpl)this.engineConfiguration).isEnableEntityLinks() && executionEntity.isProcessInstanceType() && this.isRootProcessInstance(executionEntity)) {
            EntityLinkService entityLinkService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEntityLinkServiceConfiguration().getEntityLinkService();
            boolean deleteEntityLinks = true;
            if (eventDispatcherEnabled) {
                List entityLinks = entityLinkService.findEntityLinksByRootScopeIdAndRootType(executionEntity.getId(), "bpmn");
                for (EntityLink entityLink : entityLinks) {
                    this.fireEntityDeletedEvent((Entity)((EntityLinkEntity)entityLink));
                }
                boolean bl = deleteEntityLinks = !entityLinks.isEmpty();
            }
            if (deleteEntityLinks) {
                entityLinkService.deleteEntityLinksByRootScopeIdAndType(executionEntity.getId(), "bpmn");
            }
        }
    }

    protected boolean isRootProcessInstance(ExecutionEntity executionEntity) {
        return executionEntity.getSuperExecutionId() == null && (executionEntity.getCallbackId() == null || !"cmmn-1.1-to-bpmn-2.0-child-process".equals(executionEntity.getCallbackType()));
    }

    protected void deleteVariables(ExecutionEntity executionEntity, CommandContext commandContext, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getVariableCount() > 0) {
            List variableInstances;
            FlowableEventDispatcher eventDispatcher;
            Collection executionVariables = executionEntity.getVariableInstancesLocal().values();
            if (!executionVariables.isEmpty()) {
                ArrayList<ByteArrayRef> variableByteArrayRefs = new ArrayList<ByteArrayRef>();
                for (VariableInstance variableInstance : executionVariables) {
                    if (!(variableInstance instanceof VariableInstanceEntity)) continue;
                    VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
                    if (variableInstanceEntity.getByteArrayRef() != null && variableInstanceEntity.getByteArrayRef().getId() != null) {
                        variableByteArrayRefs.add(variableInstanceEntity.getByteArrayRef());
                    }
                    if (!eventDispatcherEnabled || (eventDispatcher = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventDispatcher()) == null) continue;
                    eventDispatcher.dispatchEvent((FlowableEvent)EventUtil.createVariableDeleteEvent(variableInstanceEntity), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, variableInstance), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                }
                for (ByteArrayRef variableByteArrayRef : variableByteArrayRefs) {
                    this.getByteArrayEntityManager().deleteByteArrayById(variableByteArrayRef.getId());
                }
                ((ProcessEngineConfigurationImpl)this.engineConfiguration).getVariableServiceConfiguration().getVariableService().deleteVariablesByExecutionId(executionEntity.getId());
            }
            boolean deleteVariableInstances = !(variableInstances = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().subScopeId(executionEntity.getId()).scopeTypes(((ProcessEngineConfigurationImpl)this.engineConfiguration).getDependentScopeTypes()).list()).isEmpty();
            for (VariableInstanceEntity variableInstance : variableInstances) {
                if (eventDispatcherEnabled && (eventDispatcher = CommandContextUtil.getEventDispatcher(commandContext)) != null) {
                    eventDispatcher.dispatchEvent((FlowableEvent)EventUtil.createVariableDeleteEvent(variableInstance), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, variableInstance), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                }
                if (variableInstance.getByteArrayRef() == null || variableInstance.getByteArrayRef().getId() == null) continue;
                variableInstance.getByteArrayRef().delete(((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            }
            if (deleteVariableInstances) {
                ((ProcessEngineConfigurationImpl)this.engineConfiguration).getVariableServiceConfiguration().getVariableInstanceEntityManager().deleteBySubScopeIdAndScopeTypes(executionEntity.getId(), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getDependentScopeTypes());
            }
        }
    }

    protected void deleteUserTasks(ExecutionEntity executionEntity, String deleteReason, CommandContext commandContext, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTaskCount() > 0) {
            TaskHelper.deleteTasksForExecution(executionEntity, ((ProcessEngineConfigurationImpl)this.engineConfiguration).getTaskServiceConfiguration().getTaskService().findTasksByExecutionId(executionEntity.getId()), deleteReason);
        }
    }

    protected void deleteJobs(ExecutionEntity executionEntity, CommandContext commandContext, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTimerJobCount() > 0) {
            ((ProcessEngineConfigurationImpl)this.engineConfiguration).getJobServiceConfiguration().getTimerJobService().deleteTimerJobsByExecutionId(executionEntity.getId());
        }
        JobService jobService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getJobServiceConfiguration().getJobService();
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getJobCount() > 0) {
            jobService.deleteJobsByExecutionId(executionEntity.getId());
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getSuspendedJobCount() > 0) {
            jobService.deleteSuspendedJobsByExecutionId(executionEntity.getId());
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getDeadLetterJobCount() > 0) {
            jobService.deleteDeadLetterJobsByExecutionId(executionEntity.getId());
        }
        if (!enableExecutionRelationshipCounts || ((CountingExecutionEntity)((Object)executionEntity)).getExternalWorkerJobCount() > 0) {
            List externalWorkerJobsForExecution = jobService.findExternalWorkerJobsByExecutionId(executionEntity.getId());
            ExternalWorkerJobEntityManager externalWorkerJobEntityManager = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getJobServiceConfiguration().getExternalWorkerJobEntityManager();
            IdentityLinkService identityLinkService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkService();
            for (ExternalWorkerJobEntity job : externalWorkerJobsForExecution) {
                externalWorkerJobEntityManager.delete((Entity)job);
                identityLinkService.deleteIdentityLinksByScopeIdAndType(job.getCorrelationId(), "externalWorker");
                if (this.getEventDispatcher() == null || !this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.JOB_CANCELED, (Object)job), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            }
        }
    }

    protected void deleteEventSubScriptions(ExecutionEntity executionEntity, boolean enableExecutionRelationshipCounts, boolean eventDispatcherEnabled) {
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getEventSubscriptionCount() > 0) {
            EventSubscriptionService eventSubscriptionService = ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
            boolean deleteEventSubscriptions = true;
            if (eventDispatcherEnabled) {
                List eventSubscriptions = eventSubscriptionService.findEventSubscriptionsByExecution(executionEntity.getId());
                for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                    this.fireEntityDeletedEvent((Entity)eventSubscription);
                    if (!"message".equals(eventSubscription.getEventType())) continue;
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMessageEvent(FlowableEngineEventType.ACTIVITY_MESSAGE_CANCELLED, eventSubscription.getActivityId(), eventSubscription.getEventName(), null, eventSubscription.getExecutionId(), eventSubscription.getProcessInstanceId(), eventSubscription.getProcessDefinitionId()), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
                }
                boolean bl = deleteEventSubscriptions = !eventSubscriptions.isEmpty();
            }
            if (deleteEventSubscriptions) {
                eventSubscriptionService.deleteEventSubscriptionsByExecutionId(executionEntity.getId());
            }
        }
    }

    @Override
    public void updateProcessInstanceLockTime(String processInstanceId, String lockOwner, Date lockTime) {
        Date expirationTime = this.getClock().getCurrentTime();
        ((ExecutionDataManager)this.dataManager).updateProcessInstanceLockTime(processInstanceId, lockTime, lockOwner, expirationTime);
    }

    @Override
    public void clearProcessInstanceLockTime(String processInstanceId) {
        ((ExecutionDataManager)this.dataManager).clearProcessInstanceLockTime(processInstanceId);
    }

    @Override
    public void clearAllProcessInstanceLockTimes(String lockOwner) {
        ((ExecutionDataManager)this.dataManager).clearAllProcessInstanceLockTimes(lockOwner);
    }

    @Override
    public String updateProcessInstanceBusinessKey(ExecutionEntity executionEntity, String businessKey) {
        if (executionEntity.isProcessInstanceType() && businessKey != null) {
            executionEntity.setBusinessKey(businessKey);
            this.getHistoryManager().updateProcessBusinessKeyInHistory(executionEntity);
            if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, executionEntity), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            }
            return businessKey;
        }
        return null;
    }

    @Override
    public String updateProcessInstanceBusinessStatus(ExecutionEntity executionEntity, String businessStatus) {
        if (executionEntity.isProcessInstanceType() && businessStatus != null) {
            executionEntity.setBusinessStatus(businessStatus);
            this.getHistoryManager().updateProcessBusinessStatusInHistory(executionEntity);
            if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, executionEntity), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            }
            return businessStatus;
        }
        return null;
    }

    protected HistoryManager getHistoryManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getHistoryManager();
    }

    protected AsyncExecutor getAsyncExecutor() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getAsyncExecutor();
    }

    protected ByteArrayEntityManager getByteArrayEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getByteArrayEntityManager();
    }

    protected ActivityInstanceEntityManager getActivityInstanceEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getActivityInstanceEntityManager();
    }
}

