/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CheckWebAuthenticationRequestAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckWebAuthenticationRequestAction.class);
    private final String contentType;

    protected Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        LOGGER.trace("Checking request content type [{}] against [{}]", (Object)request.getContentType(), (Object)this.contentType);
        String requestContentType = request.getContentType();
        if (StringUtils.isNotBlank((CharSequence)requestContentType) && RegexUtils.find((String)this.contentType, (String)requestContentType)) {
            LOGGER.debug("Authentication request via type [{}] is not web-based", (Object)this.contentType);
            return new EventFactorySupport().no((Object)this);
        }
        LOGGER.debug("Authenticated request is identified as web-based via type [{}]", (Object)requestContentType);
        return new EventFactorySupport().yes((Object)this);
    }

    @Generated
    public CheckWebAuthenticationRequestAction(String contentType) {
        this.contentType = contentType;
    }
}

