/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;

public abstract class AbstractAuthProfileLogic
extends AbstractTransactionalLogic<AuthProfileTO> {
    protected final AuthProfileDAO authProfileDAO;
    protected final AuthProfileDataBinder binder;

    public AbstractAuthProfileLogic(AuthProfileDAO authProfileDAO, AuthProfileDataBinder binder) {
        this.authProfileDAO = authProfileDAO;
        this.binder = binder;
    }

    protected AuthProfileTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof AuthProfileTO)) continue;
                key = ((AuthProfileTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAuthProfileTO(this.authProfileDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

