/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.test.IdmTestHelper;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class FlowableIdmRule
implements TestRule {
    protected String configurationResource = "flowable.idm.cfg.xml";
    protected String deploymentId;
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected IdmEngine idmEngine;
    protected IdmIdentityService identityService;

    public FlowableIdmRule() {
    }

    public FlowableIdmRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableIdmRule(IdmEngine idmEngine) {
        this.setIdmEngine(idmEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableIdmRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableIdmRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableIdmRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableIdmRule.this.failedQuietly(t, description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.idmEngine == null) {
            this.initializeIdmEngine();
        }
        if (this.idmEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureIdmEngine();
    }

    protected void initializeIdmEngine() {
        this.idmEngine = IdmTestHelper.getIdmEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.idmEngineConfiguration = this.idmEngine.getIdmEngineConfiguration();
        this.identityService = this.idmEngine.getIdmIdentityService();
    }

    protected void configureIdmEngine() {
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public IdmEngine getIdmEngine() {
        return this.idmEngine;
    }

    public void setIdmEngine(IdmEngine idmEngine) {
        this.idmEngine = idmEngine;
        this.initializeServices();
    }

    public IdmIdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdmIdentityService identityService) {
        this.identityService = identityService;
    }

    public void setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
    }
}

