/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.LinkedAccountsStatusModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.status.ReconStatusPanel;
import org.apache.syncope.client.console.status.ReconStatusUtils;
import org.apache.syncope.client.console.status.ReconTaskPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.status.Status;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AnyStatusDirectoryPanel
extends DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?>>
implements ModalPanel {
    private static final long serialVersionUID = -9148734710505211261L;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    @SpringBean
    protected ReconStatusUtils reconStatusUtils;
    @SpringBean
    protected UserRestClient userRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected AnyObjectRestClient anyObjectRestClient;
    protected final MultilevelPanel multiLevelPanelRef;
    protected final AnyTO anyTO;
    protected final AnyTypeKind anyTypeKind;
    protected final boolean statusOnly;
    private final List<String> resources;

    public AnyStatusDirectoryPanel(MultilevelPanel multiLevelPanelRef, PageReference pageRef, AnyTO anyTO, String itemKeyFieldName, boolean statusOnly) {
        super("first", null, pageRef);
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.statusOnly = statusOnly;
        this.anyTO = anyTO;
        this.itemKeyFieldName = itemKeyFieldName;
        if (anyTO instanceof UserTO) {
            this.restClient = this.userRestClient;
            this.anyTypeKind = AnyTypeKind.USER;
        } else if (anyTO instanceof GroupTO) {
            this.restClient = this.groupRestClient;
            this.anyTypeKind = AnyTypeKind.GROUP;
        } else {
            this.restClient = this.anyObjectRestClient;
            this.anyTypeKind = AnyTypeKind.ANY_OBJECT;
        }
        this.resources = this.resourceRestClient.list().stream().filter(resource -> resource.getProvision(anyTO.getType()).isPresent()).map(ResourceTO::getKey).collect(Collectors.toList());
        this.initResultTable();
    }

    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<StatusBean, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.multiLevelPanelRef);
    }

    protected List<IColumn<StatusBean, String>> getColumns() {
        ArrayList<IColumn<StatusBean, String>> columns = new ArrayList<IColumn<StatusBean, String>>();
        columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("resource", (Component)this), "resource"){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, final IModel<StatusBean> model) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((StatusBean)model.getObject()).getResource())){
                    private static final long serialVersionUID = 8432079838783825801L;

                    protected void onComponentTag(ComponentTag tag) {
                        if (AnyStatusDirectoryPanel.this.anyTO.getResources().contains(((StatusBean)model.getObject()).getResource()) || "syncope".equalsIgnoreCase(((StatusBean)model.getObject()).getResource())) {
                            super.onComponentTag(tag);
                        } else {
                            tag.put("style", (CharSequence)"font-style: italic");
                        }
                    }
                }});
            }
        });
        if (this.statusOnly) {
            columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("connObjectLink", (Component)this), (Object)"connObjectLink", "connObjectLink"));
            columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("status", (Component)this)){
                private static final long serialVersionUID = -3503023501954863131L;

                public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, IModel<StatusBean> model) {
                    if (((StatusBean)model.getObject()).isLinked()) {
                        cellItem.add(new Component[]{StatusUtils.getStatusImage((String)componentId, (Status)((StatusBean)model.getObject()).getStatus())});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)""))});
                    }
                }
            });
        }
        return columns;
    }

    public ActionsPanel<StatusBean> getActions(IModel<StatusBean> model) {
        UserTO userTO;
        ActionsPanel panel = super.getActions(model);
        if (!"syncope".equalsIgnoreCase(((StatusBean)model.getObject()).getResource())) {
            panel.add((ActionLink)new ActionLink<StatusBean>(){
                private static final long serialVersionUID = -7978723352517770645L;

                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next(bean.getResource(), (MultilevelPanel.SecondLevel)new ReconStatusPanel(bean.getResource(), AnyStatusDirectoryPanel.this.anyTO.getType(), AnyStatusDirectoryPanel.this.anyTO.getKey()), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT");
        }
        if (!this.statusOnly) {
            panel.add((ActionLink)new ActionLink<StatusBean>(){
                private static final long serialVersionUID = -7978723352517770645L;

                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next("PUSH " + bean.getResource(), (MultilevelPanel.SecondLevel)new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PushTaskTO(), AnyStatusDirectoryPanel.this.anyTO.getType(), AnyStatusDirectoryPanel.this.anyTO.getKey(), true, AnyStatusDirectoryPanel.this.multiLevelPanelRef, AnyStatusDirectoryPanel.this.pageRef), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.RECONCILIATION_PUSH, "TASK_EXECUTE");
            panel.add((ActionLink)new ActionLink<StatusBean>(){
                private static final long serialVersionUID = -7978723352517770645L;

                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next("PULL " + bean.getResource(), (MultilevelPanel.SecondLevel)new ReconTaskPanel(bean.getResource(), (ProvisioningTaskTO)new PullTaskTO(), AnyStatusDirectoryPanel.this.anyTO.getType(), AnyStatusDirectoryPanel.this.anyTO.getKey(), true, AnyStatusDirectoryPanel.this.multiLevelPanelRef, AnyStatusDirectoryPanel.this.pageRef), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.RECONCILIATION_PULL, "TASK_EXECUTE");
        }
        if (this.anyTO instanceof UserTO && !((UserTO)UserTO.class.cast(this.anyTO)).getLinkedAccounts().isEmpty() && !(userTO = (UserTO)UserTO.class.cast(this.anyTO)).getLinkedAccounts().isEmpty() && userTO.getLinkedAccounts().stream().anyMatch(linkedAccountTO -> linkedAccountTO.getResource().equals(((StatusBean)model.getObject()).getResource()))) {
            panel.add((ActionLink)new ActionLink<StatusBean>(){
                private static final long serialVersionUID = 5168094747477174155L;

                public void onClick(AjaxRequestTarget target, StatusBean bean) {
                    AnyStatusDirectoryPanel.this.multiLevelPanelRef.next("ACCOUNTS", (MultilevelPanel.SecondLevel)new LinkedAccountsStatusModalPanel((IModel<UserTO>)Model.of((Serializable)((UserTO)UserTO.class.cast(AnyStatusDirectoryPanel.this.anyTO))), AnyStatusDirectoryPanel.this.pageRef), target);
                    target.add(new Component[]{AnyStatusDirectoryPanel.this.multiLevelPanelRef});
                    AnyStatusDirectoryPanel.this.getTogglePanel().close(target);
                }
            }, ActionLink.ActionType.MANAGE_ACCOUNTS, String.format("%s,%s,%s", "USER_READ", "USER_UPDATE", "RESOURCE_GET_CONNOBJECT"));
        }
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        if (this.statusOnly) {
            batches.add(ActionLink.ActionType.SUSPEND);
            batches.add(ActionLink.ActionType.REACTIVATE);
        } else {
            batches.add(ActionLink.ActionType.UNLINK);
            batches.add(ActionLink.ActionType.LINK);
            batches.add(ActionLink.ActionType.DEPROVISION);
            batches.add(ActionLink.ActionType.PROVISION);
            batches.add(ActionLink.ActionType.ASSIGN);
            batches.add(ActionLink.ActionType.UNASSIGN);
        }
        return batches;
    }

    protected AnyStatusProvider dataProvider() {
        return new AnyStatusProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "resource.status.paginator.rows";
    }

    protected class AnyStatusProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4586969457669796621L;

        AnyStatusProvider(int paginatorRows) {
            super(paginatorRows, "resource");
        }

        @Override
        protected List<StatusBean> getStatusBeans(long first, long count) {
            AnyTO actual = ((AbstractAnyRestClient)AnyStatusDirectoryPanel.this.restClient).read(AnyStatusDirectoryPanel.this.anyTO.getKey());
            List<StatusBean> statusBeans = actual.getResources().stream().map(resource -> {
                List<Object> statuses = List.of();
                if (AnyStatusDirectoryPanel.this.statusOnly) {
                    statuses = AnyStatusDirectoryPanel.this.reconStatusUtils.getReconStatuses(AnyStatusDirectoryPanel.this.anyTO.getType(), AnyStatusDirectoryPanel.this.anyTO.getKey(), List.of(resource));
                }
                return StatusUtils.getStatusBean((AnyTO)actual, (String)resource, statuses.isEmpty() ? null : ((ReconStatus)((Pair)statuses.get(0)).getRight()).getOnResource(), (boolean)(actual instanceof GroupTO));
            }).collect(Collectors.toList());
            if (AnyStatusDirectoryPanel.this.statusOnly) {
                StatusBean syncope = new StatusBean(actual, "syncope");
                switch (AnyStatusDirectoryPanel.this.anyTypeKind) {
                    case USER: {
                        syncope.setConnObjectLink(((UserTO)actual).getUsername());
                        break;
                    }
                    case GROUP: {
                        syncope.setConnObjectLink(((GroupTO)actual).getName());
                        break;
                    }
                    case ANY_OBJECT: {
                        syncope.setConnObjectLink(((AnyObjectTO)actual).getName());
                        break;
                    }
                }
                Status syncopeStatus = Status.UNDEFINED;
                if (actual.getStatus() != null) {
                    try {
                        syncopeStatus = Status.valueOf((String)actual.getStatus().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Unexpected status found: {}", (Object)actual.getStatus(), (Object)e);
                    }
                }
                syncope.setStatus(syncopeStatus);
                statusBeans.sort((Comparator<StatusBean>)this.comparator);
                statusBeans.add(0, syncope);
            } else {
                statusBeans.addAll(AnyStatusDirectoryPanel.this.resources.stream().filter(resource -> !actual.getResources().contains(resource)).map(resource -> {
                    StatusBean statusBean = StatusUtils.getStatusBean((AnyTO)actual, (String)resource, null, (boolean)(actual instanceof GroupTO));
                    statusBean.setLinked(false);
                    return statusBean;
                }).collect(Collectors.toList()));
                statusBeans.sort((Comparator<StatusBean>)this.comparator);
            }
            return first == -1L && count == -1L ? statusBeans : statusBeans.subList((int)first, (int)first + (int)count);
        }
    }
}

