/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.lib.WebClientBuilder;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.PagedConnObjectResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;
import org.apache.syncope.common.rest.api.service.ResourceService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class ResourceRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6898907679835668987L;

    public boolean check(String coreAddress, String domain, String jwt, String key) throws IOException {
        WebClient client = WebClientBuilder.build((String)coreAddress).path((Object)"resources").accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE).header("X-Syncope-Domain", new Object[]{domain}).authorization((Object)("Bearer " + jwt));
        Response response = client.path((Object)key).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            response = client.back(false).path((Object)"check").post((Object)IOUtils.toString((InputStream)((InputStream)response.getEntity()), (Charset)StandardCharsets.UTF_8));
            return response.getStatus() == Response.Status.NO_CONTENT.getStatusCode();
        }
        return false;
    }

    public Pair<Boolean, String> check(ResourceTO resourceTO) {
        boolean check = false;
        String errorMessage = null;
        try {
            ((ResourceService)this.getService(ResourceService.class)).check(resourceTO);
            check = true;
        }
        catch (Exception e) {
            LOG.error("Connector not found {}", (Object)resourceTO.getConnector(), (Object)e);
            errorMessage = e.getMessage();
        }
        return Pair.of((Object)check, (Object)errorMessage);
    }

    public ConnObject readConnObject(String resource, String anyTypeKey, String anyKey) {
        return ((ResourceService)this.getService(ResourceService.class)).readConnObject(resource, anyTypeKey, anyKey);
    }

    public String getConnObjectKeyValue(String resource, String anyTypeKey, String anyKey) {
        try {
            Response response = ((ResourceService)this.getService(ResourceService.class)).getConnObjectKeyValue(resource, anyTypeKey, anyKey);
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                return response.getHeaderString("X-Syncope-ConnObject-Key");
            }
        }
        catch (Exception e) {
            LOG.debug("Error fetching connector object key", (Throwable)e);
        }
        LOG.error("Unable to determine connector object key value for resource {}, {} and {}", new Object[]{resource, anyTypeKey, anyKey});
        return null;
    }

    public Pair<String, List<ConnObject>> searchConnObjects(String resource, String anyTypeKey, ConnObjectTOQuery.Builder queryBuilder, SortParam<String> sortParam) {
        ArrayList result = new ArrayList();
        String nextPageResultCookie = null;
        try {
            if (sortParam != null) {
                queryBuilder.orderBy(ResourceRestClient.toOrderBy(sortParam));
            }
            PagedConnObjectResult list = ((ResourceService)this.getService(ResourceService.class)).searchConnObjects(resource, anyTypeKey, queryBuilder.build());
            result.addAll(list.getResult());
            nextPageResultCookie = list.getPagedResultsCookie();
        }
        catch (Exception e) {
            LOG.error("While listing objects on {} for any type {}", new Object[]{resource, anyTypeKey, e});
        }
        return Pair.of((Object)nextPageResultCookie, result);
    }

    public ResourceTO read(String name) {
        return ((ResourceService)this.getService(ResourceService.class)).read(name);
    }

    public List<ResourceTO> list() {
        List resources = List.of();
        try {
            resources = ((ResourceService)this.getService(ResourceService.class)).list();
            resources.sort(Comparator.comparing(ResourceTO::getKey));
        }
        catch (Exception e) {
            LOG.error("Could not fetch the Resource list", (Throwable)e);
        }
        return resources;
    }

    public ResourceTO create(ResourceTO resourceTO) {
        ResourceService service = (ResourceService)this.getService(ResourceService.class);
        Response response = service.create(resourceTO);
        return (ResourceTO)this.getObject((JAXRSService)service, response.getLocation(), ResourceTO.class);
    }

    public void update(ResourceTO resourceTO) {
        ((ResourceService)this.getService(ResourceService.class)).update(resourceTO);
    }

    public void delete(String name) {
        ((ResourceService)this.getService(ResourceService.class)).delete(name);
    }

    public void setLatestSyncToken(String key, String anyType) {
        ((ResourceService)this.getService(ResourceService.class)).setLatestSyncToken(key, anyType);
    }

    public void removeSyncToken(String key, String anyType) {
        ((ResourceService)this.getService(ResourceService.class)).removeSyncToken(key, anyType);
    }
}

