/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketImpl;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketImpl;
import org.apereo.cas.ticket.serialization.TicketSerializationExecutionPlanConfigurer;
import org.apereo.cas.util.serialization.AbstractJacksonBackedStringSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SAMLIdentityProvider)
@AutoConfiguration
public class SamlIdPTicketSerializationConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketSerializationExecutionPlanConfigurer samlIdPTicketSerializationExecutionPlanConfigurer() {
        return plan -> {
            plan.registerTicketSerializer((StringSerializer)new SamlArtifactTicketStringSerializer());
            plan.registerTicketSerializer((StringSerializer)new SamlAttributeQueryTicketStringSerializer());
            plan.registerTicketSerializer(SamlArtifactTicket.class.getName(), (StringSerializer)new SamlArtifactTicketStringSerializer());
            plan.registerTicketSerializer(SamlAttributeQueryTicket.class.getName(), (StringSerializer)new SamlAttributeQueryTicketStringSerializer());
        };
    }

    private static class SamlAttributeQueryTicketStringSerializer
    extends AbstractJacksonBackedStringSerializer<SamlAttributeQueryTicketImpl> {
        private static final long serialVersionUID = -2198623586274810263L;

        private SamlAttributeQueryTicketStringSerializer() {
        }

        public Class<SamlAttributeQueryTicketImpl> getTypeToSerialize() {
            return SamlAttributeQueryTicketImpl.class;
        }
    }

    private static class SamlArtifactTicketStringSerializer
    extends AbstractJacksonBackedStringSerializer<SamlArtifactTicketImpl> {
        private static final long serialVersionUID = -2198623586274810263L;

        private SamlArtifactTicketStringSerializer() {
        }

        public Class<SamlArtifactTicketImpl> getTypeToSerialize() {
            return SamlArtifactTicketImpl.class;
        }
    }
}

