/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.orm.jpa;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.hibernate.SessionFactory;
import org.hibernate.stat.HibernateMetrics;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={MetricsAutoConfiguration.class, HibernateJpaAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={EntityManagerFactory.class, SessionFactory.class, HibernateMetrics.class, MeterRegistry.class})
@ConditionalOnBean(value={EntityManagerFactory.class, MeterRegistry.class})
public class HibernateMetricsAutoConfiguration
implements SmartInitializingSingleton {
    private static final String ENTITY_MANAGER_FACTORY_SUFFIX = "entityManagerFactory";
    private final Map<String, EntityManagerFactory> entityManagerFactories;
    private final MeterRegistry meterRegistry;

    public HibernateMetricsAutoConfiguration(Map<String, EntityManagerFactory> entityManagerFactories, MeterRegistry meterRegistry) {
        this.entityManagerFactories = entityManagerFactories;
        this.meterRegistry = meterRegistry;
    }

    public void afterSingletonsInstantiated() {
        this.bindEntityManagerFactoriesToRegistry(this.entityManagerFactories, this.meterRegistry);
    }

    public void bindEntityManagerFactoriesToRegistry(Map<String, EntityManagerFactory> entityManagerFactories, MeterRegistry registry) {
        entityManagerFactories.forEach((name, factory) -> this.bindEntityManagerFactoryToRegistry((String)name, (EntityManagerFactory)factory, registry));
    }

    private void bindEntityManagerFactoryToRegistry(String beanName, EntityManagerFactory entityManagerFactory, MeterRegistry registry) {
        String entityManagerFactoryName = this.getEntityManagerFactoryName(beanName);
        try {
            new HibernateMetrics((SessionFactory)entityManagerFactory.unwrap(SessionFactory.class), entityManagerFactoryName, Collections.emptyList()).bindTo(registry);
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    private String getEntityManagerFactoryName(String beanName) {
        if (beanName.length() > ENTITY_MANAGER_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)ENTITY_MANAGER_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - ENTITY_MANAGER_FACTORY_SUFFIX.length());
        }
        return beanName;
    }
}

