/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.dmn.api.ExpressionExecution;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RuleExecutionAuditContainer {
    protected Date startTime;
    protected Date endTime;
    protected int ruleNumber;
    protected Boolean valid = Boolean.FALSE;
    @JsonProperty(value="exception")
    protected String exceptionMessage;
    protected String validationMessage;
    protected List<ExpressionExecution> conditionResults = new ArrayList<ExpressionExecution>();
    protected List<ExpressionExecution> conclusionResults = new ArrayList<ExpressionExecution>();

    public RuleExecutionAuditContainer(int ruleNumber) {
        this.ruleNumber = ruleNumber;
        this.startTime = new Date();
    }

    public void addConditionResult(ExpressionExecution expressionExecution) {
        this.conditionResults.add(expressionExecution);
    }

    public void addConclusionResult(ExpressionExecution executionResult) {
        this.conclusionResults.add(executionResult);
    }

    public void markRuleEnd() {
        this.endTime = new Date();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public Boolean isValid() {
        return this.valid;
    }

    public void setValid() {
        this.valid = Boolean.TRUE;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public List<ExpressionExecution> getConditionResults() {
        return this.conditionResults;
    }

    public List<ExpressionExecution> getConclusionResults() {
        return this.conclusionResults;
    }
}

