/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.rabbit;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.flowable.eventregistry.api.InboundEvent;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class RabbitInboundEvent
implements InboundEvent {
    protected final Message message;
    protected Collection<String> stringContentTypes;
    protected Map<String, Object> headers;

    public RabbitInboundEvent(Message message) {
        this.message = message;
        this.stringContentTypes = new HashSet<String>();
        this.stringContentTypes.add("application/json");
        this.stringContentTypes.add("text/x-json");
        this.stringContentTypes.add("text/plain");
        this.stringContentTypes.add("application/xml");
    }

    public Object getRawEvent() {
        return this.message;
    }

    public Object getBody() {
        byte[] body = this.message.getBody();
        MessageProperties messageProperties = this.message.getMessageProperties();
        String contentType = messageProperties != null ? messageProperties.getContentType() : null;
        String bodyContent = null;
        bodyContent = this.stringContentTypes.contains(contentType) ? new String(body, StandardCharsets.UTF_8) : Base64.getEncoder().encodeToString(body);
        return bodyContent;
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.retrieveHeaders();
        }
        return this.headers;
    }

    protected Map<String, Object> retrieveHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Map headerMap = this.message.getMessageProperties().getHeaders();
        for (String headerName : headerMap.keySet()) {
            headers.put(headerName, headerMap.get(headerName));
        }
        return headers;
    }

    public Collection<String> getStringContentTypes() {
        return this.stringContentTypes;
    }

    public void setStringContentTypes(Collection<String> stringContentTypes) {
        this.stringContentTypes = stringContentTypes;
    }
}

