/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class AssertionRequest {
    @NonNull
    private final PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
    private final String username;

    @JsonCreator
    private AssertionRequest(@JsonProperty(value="publicKeyCredentialRequestOptions") @NonNull PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, @JsonProperty(value="username") String username) {
        if (publicKeyCredentialRequestOptions == null) {
            throw new NullPointerException("publicKeyCredentialRequestOptions is marked non-null but is null");
        }
        this.publicKeyCredentialRequestOptions = publicKeyCredentialRequestOptions;
        this.username = username;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public String toCredentialsGetJson() throws JsonProcessingException {
        return this.publicKeyCredentialRequestOptions.toCredentialsGetJson();
    }

    public String toJson() throws JsonProcessingException {
        return JacksonCodecs.json().writeValueAsString((Object)this);
    }

    public static AssertionRequest fromJson(String json) throws JsonProcessingException {
        return (AssertionRequest)JacksonCodecs.json().readValue(json, AssertionRequest.class);
    }

    public static AssertionRequestBuilder.MandatoryStages builder() {
        return new AssertionRequestBuilder.MandatoryStages();
    }

    @Generated
    public AssertionRequestBuilder toBuilder() {
        return new AssertionRequestBuilder().publicKeyCredentialRequestOptions(this.publicKeyCredentialRequestOptions).username(this.username);
    }

    @NonNull
    @Generated
    public PublicKeyCredentialRequestOptions getPublicKeyCredentialRequestOptions() {
        return this.publicKeyCredentialRequestOptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionRequest)) {
            return false;
        }
        AssertionRequest other = (AssertionRequest)o;
        PublicKeyCredentialRequestOptions this$publicKeyCredentialRequestOptions = this.getPublicKeyCredentialRequestOptions();
        PublicKeyCredentialRequestOptions other$publicKeyCredentialRequestOptions = other.getPublicKeyCredentialRequestOptions();
        if (this$publicKeyCredentialRequestOptions == null ? other$publicKeyCredentialRequestOptions != null : !((Object)this$publicKeyCredentialRequestOptions).equals(other$publicKeyCredentialRequestOptions)) {
            return false;
        }
        Optional<String> this$username = this.getUsername();
        Optional<String> other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !((Object)this$username).equals(other$username));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKeyCredentialRequestOptions $publicKeyCredentialRequestOptions = this.getPublicKeyCredentialRequestOptions();
        result = result * 59 + ($publicKeyCredentialRequestOptions == null ? 43 : ((Object)$publicKeyCredentialRequestOptions).hashCode());
        Optional<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssertionRequest(publicKeyCredentialRequestOptions=" + this.getPublicKeyCredentialRequestOptions() + ", username=" + this.getUsername() + ")";
    }

    public static class AssertionRequestBuilder {
        @Generated
        private PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions;
        private String username = null;

        public AssertionRequestBuilder username(@NonNull Optional<String> username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            return this.username((String)username.orElse(null));
        }

        public AssertionRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        AssertionRequestBuilder() {
        }

        @Generated
        public AssertionRequestBuilder publicKeyCredentialRequestOptions(@NonNull PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
            if (publicKeyCredentialRequestOptions == null) {
                throw new NullPointerException("publicKeyCredentialRequestOptions is marked non-null but is null");
            }
            this.publicKeyCredentialRequestOptions = publicKeyCredentialRequestOptions;
            return this;
        }

        @Generated
        public AssertionRequest build() {
            return new AssertionRequest(this.publicKeyCredentialRequestOptions, this.username);
        }

        @Generated
        public String toString() {
            return "AssertionRequest.AssertionRequestBuilder(publicKeyCredentialRequestOptions=" + this.publicKeyCredentialRequestOptions + ", username=" + this.username + ")";
        }

        public static class MandatoryStages {
            private final AssertionRequestBuilder builder = new AssertionRequestBuilder();

            public AssertionRequestBuilder publicKeyCredentialRequestOptions(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
                return this.builder.publicKeyCredentialRequestOptions(publicKeyCredentialRequestOptions);
            }
        }
    }
}

