/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.yubico.u2f.crypto.BouncyCastleCrypto;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.crypto.Crypto;
import com.yubico.u2f.crypto.RandomChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.SignRequest;
import com.yubico.u2f.data.messages.SignResponse;
import com.yubico.u2f.data.messages.key.RawRegisterResponse;
import com.yubico.u2f.data.messages.key.RawSignResponse;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fAuthenticationException;
import com.yubico.u2f.exceptions.U2fBadInputException;
import com.yubico.u2f.exceptions.U2fRegistrationException;
import java.util.Set;

@Deprecated
public class U2fPrimitives {
    private static final String SIGN_TYPE = "navigator.id.getAssertion";
    private static final String REGISTER_TYPE = "navigator.id.finishEnrollment";
    public static final String U2F_VERSION = "U2F_V2";
    private final Crypto crypto;
    private final ChallengeGenerator challengeGenerator;

    public U2fPrimitives(Crypto crypto, ChallengeGenerator challengeGenerator) {
        this.crypto = crypto;
        this.challengeGenerator = challengeGenerator;
    }

    public U2fPrimitives() {
        this(new BouncyCastleCrypto(), new RandomChallengeGenerator());
    }

    public RegisterRequest startRegistration(String appId) {
        return this.startRegistration(appId, this.challengeGenerator.generateChallenge());
    }

    public RegisterRequest startRegistration(String appId, byte[] challenge) {
        return new RegisterRequest(U2fB64Encoding.encode(challenge), appId);
    }

    public DeviceRegistration finishRegistration(RegisterRequest registerRequest, RegisterResponse response) throws U2fRegistrationException {
        return this.finishRegistration(registerRequest, response, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequest registerRequest, RegisterResponse response, Set<String> facets) throws U2fRegistrationException {
        try {
            ClientData clientData = response.getClientData();
            clientData.checkContent(REGISTER_TYPE, registerRequest.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
            RawRegisterResponse rawRegisterResponse = RawRegisterResponse.fromBase64(response.getRegistrationData(), this.crypto);
            rawRegisterResponse.checkSignature(registerRequest.getAppId(), clientData.asJson());
            return rawRegisterResponse.createDevice();
        }
        catch (U2fBadInputException e) {
            throw new U2fRegistrationException("finishRegistration failed", e);
        }
    }

    public SignRequest startSignature(String appId, DeviceRegistration deviceRegistration) {
        return this.startSignature(appId, deviceRegistration, this.challengeGenerator.generateChallenge());
    }

    public SignRequest startSignature(String appId, DeviceRegistration deviceRegistration, byte[] challenge) {
        Preconditions.checkArgument((!deviceRegistration.isCompromised() ? 1 : 0) != 0, (Object)"Device has been marked as compromised, cannot sign.");
        return SignRequest.builder().appId(appId).challenge(U2fB64Encoding.encode(challenge)).keyHandle(deviceRegistration.getKeyHandle()).build();
    }

    public void finishSignature(SignRequest signRequest, SignResponse response, DeviceRegistration deviceRegistration) throws U2fAuthenticationException {
        this.finishSignature(signRequest, response, deviceRegistration, null);
    }

    public void finishSignature(SignRequest signRequest, SignResponse response, DeviceRegistration deviceRegistration, Set<String> facets) throws U2fAuthenticationException {
        Preconditions.checkArgument((!deviceRegistration.isCompromised() ? 1 : 0) != 0, (Object)"Device has been marked as compromised, cannot sign.");
        Preconditions.checkArgument((boolean)signRequest.getKeyHandle().equals(deviceRegistration.getKeyHandle()), (Object)"Wrong DeviceRegistration for the given SignRequest");
        if (!deviceRegistration.getKeyHandle().equals(response.getKeyHandle())) {
            throw new U2fAuthenticationException("KeyHandle of SignResponse does not match");
        }
        try {
            ClientData clientData = response.getClientData();
            clientData.checkContent(SIGN_TYPE, signRequest.getChallenge(), (Optional<Set<String>>)Optional.fromNullable(facets));
            RawSignResponse rawSignResponse = RawSignResponse.fromBase64(response.getSignatureData(), this.crypto);
            rawSignResponse.checkSignature(signRequest.getAppId(), clientData.asJson(), U2fB64Encoding.decode(deviceRegistration.getPublicKey()));
            rawSignResponse.checkUserPresence();
            deviceRegistration.checkAndUpdateCounter(rawSignResponse.getCounter());
        }
        catch (U2fBadInputException e) {
            throw new U2fAuthenticationException("finishSignature failed", e);
        }
    }
}

