/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthAccessTokenProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuth20AccessTokenExpirationPolicyBuilder
implements ExpirationPolicyBuilder<OAuth20AccessToken> {
    private static final long serialVersionUID = -3597980180617072826L;
    protected final CasConfigurationProperties casProperties;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toTicketExpirationPolicy();
    }

    public ExpirationPolicy toTicketExpirationPolicy() {
        OAuthAccessTokenProperties oauth = this.casProperties.getAuthn().getOauth().getAccessToken();
        if (this.casProperties.getLogout().isRemoveDescendantTickets()) {
            return new OAuth20AccessTokenExpirationPolicy(Beans.newDuration((String)oauth.getMaxTimeToLiveInSeconds()).getSeconds(), Beans.newDuration((String)oauth.getTimeToKillInSeconds()).getSeconds());
        }
        return new OAuth20AccessTokenExpirationPolicy.OAuthAccessTokenSovereignExpirationPolicy(Beans.newDuration((String)oauth.getMaxTimeToLiveInSeconds()).getSeconds(), Beans.newDuration((String)oauth.getTimeToKillInSeconds()).getSeconds());
    }

    @Generated
    public OAuth20AccessTokenExpirationPolicyBuilder(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Generated
    public String toString() {
        return "OAuth20AccessTokenExpirationPolicyBuilder(casProperties=" + this.casProperties + ")";
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

