/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.nimbusds.jwt.JWTClaimsSet;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.jwt.JsonWebTokenSigner;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTokenSigningAndEncryptionService
implements OAuth20TokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTokenSigningAndEncryptionService.class);

    @Override
    public JwtClaims decode(String token, Optional<OAuthRegisteredService> service) {
        return (JwtClaims)FunctionUtils.doUnchecked(() -> {
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeySigningKey(service);
            FunctionUtils.throwIf((jsonWebKey.getPublicKey() == null ? 1 : 0) != 0, () -> new IllegalArgumentException("JSON web key to validate the id token signature has no public key"));
            byte[] jwt = Objects.requireNonNull(this.verifySignature(token, jsonWebKey), "Unable to verify signature of the token using the JSON web key public key");
            String result = new String(jwt, StandardCharsets.UTF_8);
            JWTClaimsSet claims = JwtBuilder.parse((String)result);
            FunctionUtils.throwIf((boolean)StringUtils.isBlank((CharSequence)claims.getIssuer()), () -> new IllegalArgumentException("Claims do not contain an issuer"));
            this.validateIssuerClaim(claims, service);
            FunctionUtils.throwIf((boolean)StringUtils.isBlank((CharSequence)claims.getStringClaim("client_id")), () -> new IllegalArgumentException("Claims do not contain a client id claim"));
            return JwtClaims.parse((String)claims.toString());
        });
    }

    public abstract Set<String> getAllowedSigningAlgorithms(OAuthRegisteredService var1);

    protected void validateIssuerClaim(JWTClaimsSet claims, Optional<OAuthRegisteredService> service) {
        LOGGER.debug("Validating claims as [{}] with issuer [{}]", (Object)claims, (Object)claims.getIssuer());
        String iss = this.resolveIssuer(service);
        Objects.requireNonNull(iss, "Issuer cannot be null or undefined");
        FunctionUtils.throwIf((!claims.getIssuer().equalsIgnoreCase(iss) ? 1 : 0) != 0, () -> new IllegalArgumentException("Issuer assigned to claims " + claims.getIssuer() + " does not match " + iss));
    }

    protected String signToken(OAuthRegisteredService service, JwtClaims claims, PublicJsonWebKey jsonWebKey) {
        LOGGER.debug("Service [{}] is set to sign id tokens", (Object)service.getServiceId());
        return JsonWebTokenSigner.builder().key((Key)Optional.ofNullable(jsonWebKey).map(PublicJsonWebKey::getPrivateKey).orElse(null)).keyId(Optional.ofNullable(jsonWebKey).map(JsonWebKey::getKeyId).orElseGet(() -> UUID.randomUUID().toString())).algorithm(this.getJsonWebKeySigningAlgorithm(service)).allowedAlgorithms(new LinkedHashSet<String>(this.getAllowedSigningAlgorithms(service))).build().sign(claims);
    }

    protected byte[] verifySignature(String token, PublicJsonWebKey jsonWebKey) {
        return EncodingUtils.verifyJwsSignature((Key)jsonWebKey.getPublicKey(), (String)token);
    }

    protected abstract PublicJsonWebKey getJsonWebKeySigningKey(Optional<OAuthRegisteredService> var1);

    @Generated
    public BaseTokenSigningAndEncryptionService() {
    }
}

