/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class SqlcmdConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> PATH;
    public static final ConfigurationDefinition<Integer> TIMEOUT;
    public static final ConfigurationDefinition<Boolean> TEMP_KEEP;
    public static final ConfigurationDefinition<String> ARGS;
    public static final ConfigurationDefinition<String> TEMP_NAME;
    public static final ConfigurationDefinition<String> TEMP_PATH;
    public static final ConfigurationDefinition<Boolean> TEMP_OVERWRITE;
    public static final ConfigurationDefinition<String> LOG_FILE;
    public static final ConfigurationDefinition<String> EXECUTOR;
    public static final ConfigurationDefinition<String> CATALOG_NAME;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.sqlcmd");
        PATH = builder.define("path", String.class).setDescription("Path to sqlcmd executable").build();
        TIMEOUT = builder.define("timeout", Integer.class).setDescription("Seconds to wait for sqlcmd timeout").build();
        TEMP_KEEP = builder.define("keep.temp", Boolean.class).setDescription("If true, do not delete temporary sql files generated").setDefaultValue(Boolean.FALSE).build();
        TEMP_NAME = builder.define("keep.temp.name", String.class).setDescription("Optionally, specify a custom filename").build();
        TEMP_PATH = builder.define("keep.temp.path", String.class).setDescription("Optionally, specify the path in which to store the temporary files. If not specified, the files will be stored in the system's temp directory.").build();
        TEMP_OVERWRITE = builder.define("keep.temp.overwrite", Boolean.class).setDescription("If true, overwrite any files in the specified directory with the same name").setDefaultValue(Boolean.TRUE).build();
        LOG_FILE = builder.define("logFile", String.class).setDescription("Log file for SQLCMD output").build();
        ARGS = builder.define("args", String.class).setDescription("Extra arguments which will be passed to the sqlcmd executable").build();
        EXECUTOR = builder.define("executor", String.class).setDescription("Custom executor that can specified").build();
        CATALOG_NAME = builder.define("catalogName", String.class).setDescription("Database to use when running SQLCMD").build();
    }
}

