/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.client.console.commons.status;

import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.model.IModel;

public abstract class AbstractStatusBeanProvider extends DirectoryDataProvider<StatusBean> {

    private static final long serialVersionUID = 4287357360778016173L;

    protected final SortableDataProviderComparator<StatusBean> comparator;

    public AbstractStatusBeanProvider(final int paginatorRows, final String sort) {
        super(paginatorRows);

        setSort(sort, SortOrder.ASCENDING);
        comparator = new SortableDataProviderComparator<>(this);
    }

    @Override
    public Iterator<StatusBean> iterator(final long first, final long count) {
        return getStatusBeans(first, count).iterator();
    }

    @Override
    public long size() {
        return getStatusBeans(-1, -1).size();
    }

    @Override
    public IModel<StatusBean> model(final StatusBean statusBean) {
        return new IModel<>() {

            private static final long serialVersionUID = -7802635613997243712L;

            @Override
            public StatusBean getObject() {
                return statusBean;
            }
        };
    }

    protected abstract List<StatusBean> getStatusBeans(long first, long count);

}
