/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRAbstractImageEncoder;

public class JRJdk14ImageEncoder
extends JRAbstractImageEncoder {
    public static final String EXCEPTION_MESSAGE_KEY_IMAGE_WRITER_NOT_FOUND = "util.jdk14.image.writer.not.found";

    @Override
    public byte[] encode(BufferedImage bi, ImageTypeEnum imageType) throws JRException {
        String formatName = null;
        switch (imageType) {
            case GIF: {
                formatName = "gif";
                break;
            }
            case PNG: {
                formatName = "png";
                break;
            }
            case TIFF: {
                formatName = "tiff";
                break;
            }
            default: {
                formatName = "jpeg";
            }
        }
        boolean success = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            success = ImageIO.write((RenderedImage)bi, formatName, baos);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (!success) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_IMAGE_WRITER_NOT_FOUND, formatName);
        }
        return baos.toByteArray();
    }
}

