/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.oval.internal.Log;

public final class SerializableMethod
implements Serializable {
    private static final Log LOG = Log.getLog(SerializableMethod.class);
    private static final long serialVersionUID = 1L;
    private final Class<?> declaringClass;
    private transient Method method;
    private final String name;
    private final Class<?>[] parameterTypes;

    public SerializableMethod(Method method) {
        this.method = method;
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.declaringClass = method.getDeclaringClass();
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.method = this.declaringClass.getDeclaredMethod(this.name, this.parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            LOG.debug("Unexpected NoSuchMethodException occurred.", ex);
            throw new IOException(ex.getMessage());
        }
    }
}

