/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.transconsole.common.messages.BaseMessage;
import com.google.transconsole.common.messages.InvalidMessageBundleException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Bundle<T extends BaseMessage>
implements Iterable<T> {
    private String projectId;
    private String languageId;
    protected Map<String, T> messages;

    protected Map<String, T> getMessageMap() {
        return Collections.unmodifiableMap(this.messages);
    }

    public Bundle(String projectId, String languageId) {
        this.projectId = Preconditions.checkNotNull(projectId);
        this.languageId = Preconditions.checkNotNull(languageId);
        this.messages = Maps.newTreeMap();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLanguage() {
        return this.languageId;
    }

    public T getMessage(String messageId) {
        return (T)((BaseMessage)this.messages.get(messageId));
    }

    public boolean containsMessage(String messageId) {
        return this.messages.containsKey(messageId);
    }

    public List<T> getMessages() {
        return ImmutableList.copyOf(Lists.sortedCopy(this.messages.values(), new Comparator<T>(){

            @Override
            public int compare(T m1, T m2) {
                return ((BaseMessage)m1).getId().compareTo(((BaseMessage)m2).getId());
            }
        }));
    }

    public abstract void addMessage(T var1) throws InvalidMessageBundleException;

    public void removeMessage(T m) {
        this.removeMessage(((BaseMessage)m).getId());
    }

    public void removeMessage(String messageId) {
        this.messages.remove(messageId);
    }

    public void mergeBundle(Bundle<T> other) throws InvalidMessageBundleException {
        if (!this.getProjectId().equals(other.getProjectId())) {
            throw new InvalidMessageBundleException(String.format("Cannot merge bundles with different project IDs (%1$s, %2$s)", this.getProjectId(), other.getProjectId()));
        }
        if (!this.getLanguage().equals(other.getLanguage())) {
            throw new InvalidMessageBundleException(String.format("Cannot merge bundles with different languages (%1$s, %2$s)", this.getLanguage(), other.getLanguage()));
        }
        for (BaseMessage message : other.getMessages()) {
            this.addMessage(message);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.getMessages().iterator();
    }
}

