/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NamespaceVisitor;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElement;
import com.google.gxp.compiler.parser.ParsedElementVisitor;
import com.google.gxp.compiler.parser.UnknownElementError;
import java.util.List;
import java.util.Map;

public class GxpNamespace
implements Namespace {
    public static final Namespace INSTANCE = new GxpNamespace();
    private static final Map<String, ElementType> ELEMENTS = GxpNamespace.initElements();

    private GxpNamespace() {
    }

    @Override
    public String getUri() {
        return "http://google.com/2001/gxp";
    }

    @Override
    public ParsedElement createElement(AlertSink alertSink, SourcePosition sourcePosition, String displayName, String tagName, List<ParsedAttribute> attrs, List<ParsedElement> children) {
        ElementType type = ELEMENTS.get(tagName);
        if (type == null) {
            alertSink.add(new UnknownElementError(sourcePosition, this, displayName));
            return null;
        }
        return new GxpElement(sourcePosition, displayName, attrs, children, type);
    }

    private static Map<String, ElementType> initElements() {
        ImmutableMap.Builder<String, ElementType> builder = ImmutableMap.builder();
        for (ElementType type : ElementType.values()) {
            builder.put(type.name().toLowerCase().replace('_', '-'), type);
        }
        return builder.build();
    }

    @Override
    public <T> T acceptVisitor(NamespaceVisitor<T> visitor) {
        return visitor.visitGxpNamespace(this);
    }

    public static enum ElementType {
        ABBR{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitAbbrElement(element);
            }
        }
        ,
        ATTR{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitAttrElement(element);
            }
        }
        ,
        CLAUSE{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitClauseElement(element);
            }
        }
        ,
        COND{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitCondElement(element);
            }
        }
        ,
        CONSTRUCTOR{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitConstructorElement(element);
            }
        }
        ,
        ELIF{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitElifElement(element);
            }
        }
        ,
        ELSE{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitElseElement(element);
            }
        }
        ,
        EPH{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitEPHElement(element);
            }
        }
        ,
        EVAL{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitEvalElement(element);
            }
        }
        ,
        IF{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitIfElement(element);
            }
        }
        ,
        IMPLEMENTS{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitImplementsElement(element);
            }
        }
        ,
        IMPORT{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitImportElement(element);
            }
        }
        ,
        INTERFACE(true){

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitInterfaceElement(element);
            }
        }
        ,
        LOOP{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitLoopElement(element);
            }
        }
        ,
        MSG{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitMsgElement(element);
            }
        }
        ,
        NOMSG{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitNoMsgElement(element);
            }
        }
        ,
        PARAM{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitParamElement(element);
            }
        }
        ,
        PH{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitPHElement(element);
            }
        }
        ,
        TEMPLATE(true){

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitTemplateElement(element);
            }
        }
        ,
        THROWS{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitThrowsElement(element);
            }
        }
        ,
        TYPEPARAM{

            @Override
            <T> T acceptVisitor(ParsedElementVisitor<T> visitor, GxpElement element) {
                return visitor.visitTypeParamElement(element);
            }
        };

        private final boolean canBeRoot;

        private ElementType() {
            this(false);
        }

        private ElementType(boolean canBeRoot) {
            this.canBeRoot = canBeRoot;
        }

        boolean canBeRoot() {
            return this.canBeRoot;
        }

        abstract <T> T acceptVisitor(ParsedElementVisitor<T> var1, GxpElement var2);
    }

    public static class GxpElement
    extends ParsedElement {
        private final ElementType elementType;

        public GxpElement(SourcePosition sourcePostion, String displayName, List<ParsedAttribute> attrs, List<? extends ParsedElement> children, ElementType elementType) {
            super(sourcePostion, displayName, attrs, children);
            this.elementType = elementType;
        }

        public ElementType getElementType() {
            return this.elementType;
        }

        @Override
        public boolean canBeRoot() {
            return this.elementType.canBeRoot();
        }

        @Override
        public <T> T acceptVisitor(ParsedElementVisitor<T> visitor) {
            return this.elementType.acceptVisitor(visitor, this);
        }

        @Override
        protected GxpElement withChildrenImpl(List<ParsedElement> children) {
            return new GxpElement(this.getSourcePosition(), this.getDisplayName(), this.getAttributes(), children, this.elementType);
        }
    }
}

