/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;

public class BooleanConstant
extends Expression {
    private final Boolean value;

    public BooleanConstant(Node fromNode, Boolean value) {
        super(fromNode, null);
        this.value = value;
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean alwaysEquals(Expression that) {
        return that instanceof BooleanConstant && ((BooleanConstant)that).getValue() == this.getValue();
    }

    @Override
    public boolean alwaysEquals(boolean thatValue) {
        return this.value == thatValue;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitBooleanConstant(this);
    }

    public String toString() {
        return "BooleanConstant(" + this.value.toString() + ")@" + this.getSourcePosition();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof BooleanConstant && this.equals((BooleanConstant)that);
    }

    public boolean equals(BooleanConstant that) {
        return this.equalsExpression(that) && this.getValue().equals(that.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getValue());
    }
}

