/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.assignments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.assignments.ILocalAssignmentsBackend;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.generated.Assignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryAssignmentBackend
implements ILocalAssignmentsBackend {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryAssignmentBackend.class);
    private Map<String, Assignment> idToAssignment;
    private Map<String, String> idToName;
    private Map<String, String> nameToId;
    private volatile boolean isSynchronized = false;

    @Override
    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    @Override
    public void setSynchronized() {
        this.isSynchronized = true;
    }

    @Override
    public void prepare(Map conf) {
        this.idToAssignment = new ConcurrentHashMap<String, Assignment>();
        this.idToName = new ConcurrentHashMap<String, String>();
        this.nameToId = new ConcurrentHashMap<String, String>();
    }

    @Override
    public void keepOrUpdateAssignment(String stormId, Assignment assignment) {
        this.idToAssignment.put(stormId, assignment);
    }

    @Override
    public Assignment getAssignment(String stormId) {
        return this.idToAssignment.get(stormId);
    }

    @Override
    public void removeAssignment(String stormId) {
        this.idToAssignment.remove(stormId);
    }

    @Override
    public List<String> assignments() {
        if (this.idToAssignment == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.idToAssignment.keySet());
        return ret;
    }

    @Override
    public Map<String, Assignment> assignmentsInfo() {
        HashMap<String, Assignment> ret = new HashMap<String, Assignment>();
        ret.putAll(this.idToAssignment);
        return ret;
    }

    @Override
    public void syncRemoteAssignments(Map<String, byte[]> remote) {
        ConcurrentHashMap<String, Assignment> tmp = new ConcurrentHashMap<String, Assignment>();
        for (Map.Entry<String, byte[]> entry : remote.entrySet()) {
            tmp.put(entry.getKey(), ClusterUtils.maybeDeserialize(entry.getValue(), Assignment.class));
        }
        this.idToAssignment = tmp;
    }

    @Override
    public void keepStormId(String stormName, String stormId) {
        this.nameToId.put(stormName, stormId);
        this.idToName.put(stormId, stormName);
    }

    @Override
    public String getStormId(String stormName) {
        return this.nameToId.get(stormName);
    }

    @Override
    public void syncRemoteIds(Map<String, String> remote) {
        ConcurrentHashMap<String, String> tmpNameToId = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> tmpIdToName = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : remote.entrySet()) {
            tmpIdToName.put(entry.getKey(), entry.getValue());
            tmpNameToId.put(entry.getValue(), entry.getKey());
        }
        this.idToName = tmpIdToName;
        this.nameToId = tmpNameToId;
    }

    @Override
    public void deleteStormId(String stormName) {
        String id = this.nameToId.remove(stormName);
        if (null != id) {
            this.idToName.remove(id);
        }
    }

    @Override
    public void clearStateForStorm(String stormId) {
        this.idToAssignment.remove(stormId);
        String name = this.idToName.remove(stormId);
        if (null != name) {
            this.nameToId.remove(name);
        }
    }

    @Override
    public void close() {
        this.idToAssignment = null;
        this.nameToId = null;
        this.idToName = null;
    }
}

