/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import java.util.Arrays;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.servlets.resolver.internal.ServletWrapperUtil;
import org.apache.sling.servlets.resolver.internal.resource.JavaxSlingServletConfig;
import org.apache.sling.servlets.resolver.internal.resource.SlingServletConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PathBasedServletAcceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathBasedServletAcceptor.class);
    private static final String EMPTY_VALUE = ".EMPTY.";
    private static final String[] EMPTY_STRINGS = new String[0];

    PathBasedServletAcceptor() {
    }

    SlingServletConfig getSlingServletConfig(ServletConfig cfg, Servlet servlet) {
        if (cfg instanceof SlingServletConfig) {
            return (SlingServletConfig)cfg;
        }
        Object s = servlet instanceof ServletWrapperUtil.JakartaScriptOptingServletWrapper ? ((ServletWrapperUtil.JakartaScriptOptingServletWrapper)servlet).servlet : (servlet instanceof ServletWrapperUtil.JakartaScriptServletWrapper ? ((ServletWrapperUtil.JakartaScriptServletWrapper)servlet).servlet : null);
        if (s != null && s.getServletConfig() instanceof JavaxSlingServletConfig) {
            return ((JavaxSlingServletConfig)s.getServletConfig()).getSlingServletConfig();
        }
        return null;
    }

    boolean accept(SlingJakartaHttpServletRequest request, Servlet servlet) {
        String servletName = RequestUtil.getServletName((Servlet)servlet);
        SlingServletConfig config = this.getSlingServletConfig(servlet.getServletConfig(), servlet);
        if (config == null) {
            LOGGER.debug("Did not get a SlingServletConfig for {}", (Object)servletName);
            return true;
        }
        boolean accepted = true;
        Object strictPaths = config.getServiceProperty("sling.servlet.paths.strict");
        if (strictPaths != null && Boolean.valueOf(strictPaths.toString()).booleanValue()) {
            accepted = this.accept(servletName, config, "sling.servlet.extensions", true, request.getRequestPathInfo().getExtension()) && this.accept(servletName, config, "sling.servlet.selectors", true, request.getRequestPathInfo().getSelectors()) && this.accept(servletName, config, "sling.servlet.methods", false, request.getMethod());
        }
        LOGGER.debug("accepted={} for {}", (Object)accepted, (Object)servletName);
        return accepted;
    }

    private boolean accept(String servletName, SlingServletConfig config, String servicePropertyKey, boolean emptyValueApplies, String ... requestValues) {
        String[] propValues = PathBasedServletAcceptor.toStringArray(config.getServiceProperty(servicePropertyKey));
        if (propValues.length == 0) {
            LOGGER.debug("Property {} is null or empty, not checking that value for {}", (Object)servicePropertyKey, (Object)servletName);
            return true;
        }
        boolean accepted = false;
        if (propValues.length == 1 && EMPTY_VALUE.equals(propValues[0])) {
            if (!emptyValueApplies) {
                throw new InvalidPropertyException("Special value .EMPTY.  is not valid for the " + servicePropertyKey + " service property");
            }
            accepted = requestValues.length == 0 || requestValues.length == 1 && requestValues[0] == null;
        } else {
            block0: for (String rValue : requestValues) {
                for (String pValue : propValues) {
                    if (rValue == null || !rValue.equals(pValue)) continue;
                    accepted = true;
                    continue block0;
                }
            }
        }
        LOGGER.debug("accepted={} for property {} and servlet {}", new Object[]{accepted, servicePropertyKey, servletName});
        return accepted;
    }

    @NotNull
    private static String[] toStringArray(Object value) {
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Object[]) {
            Object[] objArray = (Object[])value;
            return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
        }
        return EMPTY_STRINGS;
    }

    static class InvalidPropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -119036154771528511L;

        InvalidPropertyException(String reason) {
            super(reason);
        }
    }
}

