/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.DumpContext;

public class AggregatorProvider {
    private final List<Aggregator> aggregators;

    public AggregatorProvider(List<Aggregator> aggregators) {
        this.aggregators = Collections.unmodifiableList(aggregators);
    }

    public List<Aggregator> getAggregators() {
        return this.aggregators;
    }

    public Aggregator getAggregator(Node node, String path) throws RepositoryException {
        for (Aggregator a : this.aggregators) {
            if (!a.matches(node, path)) continue;
            return a;
        }
        return null;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "aggregators");
        ctx.indent(isLast);
        Iterator<Aggregator> iter = this.aggregators.iterator();
        while (iter.hasNext()) {
            Aggregator a = iter.next();
            a.dump(ctx, !iter.hasNext());
        }
        ctx.outdent();
    }
}

