/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;

public class PropertyEntryImpl
extends HierarchyEntryImpl
implements PropertyEntry {
    private PropertyEntryImpl(NodeEntryImpl parent, Name name, EntryFactory factory) {
        super(parent, name, factory);
    }

    static PropertyEntry create(NodeEntryImpl parent, Name name, EntryFactory factory) {
        return new PropertyEntryImpl(parent, name, factory);
    }

    @Override
    ItemState doResolve() throws ItemNotFoundException, RepositoryException {
        return this.getItemStateFactory().createPropertyState(this.getWorkspaceId(), this);
    }

    @Override
    Path buildPath(boolean workspacePath) throws RepositoryException {
        Path parentPath = this.parent.buildPath(workspacePath);
        return this.getPathFactory().create(parentPath, this.getName(), true);
    }

    @Override
    public PropertyId getId() throws InvalidItemStateException, RepositoryException {
        return this.getIdFactory().createPropertyId(this.parent.getId(), this.getName());
    }

    @Override
    public PropertyId getWorkspaceId() throws InvalidItemStateException, RepositoryException {
        return this.getIdFactory().createPropertyId(this.parent.getWorkspaceId(), this.getName());
    }

    @Override
    public PropertyState getPropertyState() throws ItemNotFoundException, RepositoryException {
        return (PropertyState)this.getItemState();
    }

    @Override
    public boolean denotesNode() {
        return false;
    }

    @Override
    public void complete(Operation operation) throws RepositoryException {
        if (!(operation instanceof SetPropertyValue)) {
            throw new IllegalArgumentException();
        }
        SetPropertyValue op = (SetPropertyValue)operation;
        if (op.getPropertyState().getHierarchyEntry() != this) {
            throw new IllegalArgumentException();
        }
        switch (operation.getStatus()) {
            case 1: {
                PropertyState state = op.getPropertyState();
                if (state.getStatus() == 8) break;
                state.setStatus(1);
                break;
            }
            case 2: {
                this.revert();
                break;
            }
        }
    }
}

