/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.views;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrProperty;
import org.apache.sling.ide.eclipse.ui.views.DateTimeSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DateTimeEditor
extends Dialog {
    private final JcrProperty property;
    private TableViewer viewer;
    private Label result;
    private DateTime calendar;
    private DateTime time;
    private String dateAsString;
    private Calendar c;

    protected DateTimeEditor(Shell parentShell, JcrProperty property) {
        super(parentShell);
        this.property = property;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Modify date/time property");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData parentLayoutData = new GridData(1808);
        parentLayoutData.widthHint = 280;
        parentLayoutData.heightHint = 280;
        composite.setLayoutData((Object)parentLayoutData);
        GridLayout parentLayout = (GridLayout)composite.getLayout();
        parentLayout.numColumns = 2;
        Label label = new Label(composite, 64);
        label.setText("Modify property " + this.property.getName() + ":");
        GridData data = new GridData(1796);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        Label hline = new Label(composite, 258);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        hline.setLayoutData((Object)layoutData);
        Label dateLabel = new Label(composite, 64);
        dateLabel.setText("Date:");
        layoutData = new GridData(258);
        layoutData.widthHint = 80;
        dateLabel.setLayoutData((Object)layoutData);
        dateLabel.setFont(parent.getFont());
        this.calendar = new DateTime(composite, 1024);
        layoutData = new GridData(1072);
        layoutData.horizontalSpan = 1;
        this.calendar.setLayoutData((Object)layoutData);
        this.calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeEditor.this.updateSelection();
            }
        });
        Label timeLabel = new Label(composite, 64);
        timeLabel.setText("Time:");
        layoutData = new GridData(258);
        layoutData.widthHint = 80;
        timeLabel.setLayoutData((Object)layoutData);
        timeLabel.setFont(parent.getFont());
        this.time = new DateTime(composite, 128);
        layoutData = new GridData(1072);
        layoutData.horizontalSpan = 1;
        this.time.setLayoutData((Object)layoutData);
        this.time.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeEditor.this.updateSelection();
            }
        });
        hline = new Label(composite, 258);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        hline.setLayoutData((Object)layoutData);
        this.result = new Label(composite, 64);
        this.result.setText("Foo");
        data = new GridData(1796);
        data.horizontalSpan = 2;
        this.result.setLayoutData((Object)data);
        this.result.setFont(parent.getFont());
        this.dateAsString = this.property.getValueAsString();
        this.c = DateTimeSupport.parseAsCalendar(this.dateAsString);
        this.calendar.setDate(this.c.get(1), this.c.get(2), this.c.get(5));
        this.time.setTime(this.c.get(11), this.c.get(12), this.c.get(13));
        this.updateSelection();
        return composite;
    }

    protected void updateSelection() {
        int day = this.calendar.getDay();
        int month = this.calendar.getMonth();
        int year = this.calendar.getYear();
        int hours = this.time.getHours();
        int minutes = this.time.getMinutes();
        int seconds = this.time.getSeconds();
        this.c = new GregorianCalendar(year, month, day, hours, minutes, seconds);
        this.dateAsString = DateTimeSupport.print(this.c);
        this.result.setText(this.dateAsString);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public Date getDate() {
        return this.c.getTime();
    }
}

