/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public abstract class SetServerStringPropertyCommand
extends AbstractOperation {
    private IServerWorkingCopy server;
    private String newValue;
    private String propertyName;
    private String defaultValue;
    private String oldValue;

    public SetServerStringPropertyCommand(IServerWorkingCopy server, String propertyName, String newValue, String defaultValue) {
        super("Setting property " + propertyName + " ...");
        this.server = server;
        this.propertyName = propertyName;
        this.newValue = newValue;
        this.defaultValue = defaultValue;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.oldValue = this.server.getAttribute(this.propertyName, this.defaultValue);
        this.server.setAttribute(this.propertyName, this.newValue);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.server.setAttribute(this.propertyName, this.oldValue);
        return Status.OK_STATUS;
    }
}

