/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Simple data objects and miscellaneous utilities.
 * This package provides general purpose static methods working on primitive or basic Java types
 * ({@link org.apache.sis.util.Characters},
 *  {@link org.apache.sis.util.CharSequences},
 *  {@link org.apache.sis.util.StringBuilders},
 *  {@link org.apache.sis.util.Locales},
 *  {@link org.apache.sis.util.Numbers},
 *  {@link org.apache.sis.util.Classes}), arrays
 * ({@link org.apache.sis.util.ArraysExt}) or other standard Java types
 * ({@link org.apache.sis.util.Exceptions}).
 *
 * It defines also general purpose annotations, enumerations and exceptions.
 *
 * <p>Some other noticeable services are:</p>
 * <ul>
 *   <li>{@link org.apache.sis.util.ObjectConverters}, together with the
 *       {@link org.apache.sis.util.ObjectConverter} interface, for converting various kinds of objects.</li>
 *   <li>{@link org.apache.sis.util.Utilities}, together with the
 *       {@link org.apache.sis.util.LenientComparable} interface, for comparing objects in various ways.</li>
 * </ul>
 *
 * @author  Martin Desruisseaux (Geomatys)
 * @author  Alexis Manin (Geomatys)
 * @version 1.5
 * @since   0.3
 */
package org.apache.sis.util;
