/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.internal.shared.FeatureProjection;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.pending.geoapi.filter.SortBy;
import org.apache.sis.pending.geoapi.filter.SortOrder;
import org.apache.sis.pending.geoapi.filter.SortProperty;
import org.apache.sis.storage.sql.feature.FeatureAdapter;
import org.apache.sis.storage.sql.feature.FeatureStream;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.SelectionClause;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.util.collection.WeakValueHashMap;

final class FeatureIterator
implements Spliterator<AbstractFeature>,
AutoCloseable {
    static final int CHARACTERISTICS = 256;
    private final FeatureAdapter adapter;
    private final PreparedStatement statement;
    private ResultSet result;
    private final long estimatedSize;
    private final InfoStatements spatialInformation;
    private final FeatureIterator[] dependencies;
    private final FeatureProjection projection;

    FeatureIterator(Table table, Connection connection, boolean distinct, SelectionClause selection, SortBy<? super AbstractFeature> sort, long offset, long count, FeatureProjection projection) throws Exception {
        String filter;
        this.adapter = table.adapter(connection);
        String sql = this.adapter.sql;
        this.spatialInformation = table.database.getSpatialSchema().isPresent() ? table.database.createInfoStatements(connection) : null;
        String string = filter = selection != null ? selection.query(connection, this.spatialInformation) : null;
        if (distinct || filter != null || sort != null || (offset | count) != 0L) {
            SQLBuilder builder = new SQLBuilder(table.database);
            builder.setCatalogAndSchema(connection);
            builder.append(sql);
            if (distinct) {
                builder.insertDistinctAfterSelect();
            }
            if (filter != null) {
                builder.append(" WHERE ").append(filter);
            }
            if (sort != null) {
                String separator = " ORDER BY ";
                for (SortProperty s : sort.getSortProperties()) {
                    builder.append(separator).appendIdentifier(s.getValueReference().getXPath());
                    SortOrder order = s.getSortOrder();
                    if (order != null) {
                        builder.append(' ').append(order.toSQL());
                    }
                    separator = ", ";
                }
            }
            sql = builder.appendFetchPage(offset, count).toString();
        }
        if (filter == null) {
            long n = table.countRows(connection.getMetaData(), distinct, true) - offset;
            this.estimatedSize = count != 0L ? Math.min(n, count) : n;
        } else {
            this.estimatedSize = 0L;
        }
        this.result = connection.createStatement().executeQuery(sql);
        this.dependencies = new FeatureIterator[this.adapter.dependencies.length];
        this.projection = projection;
        this.statement = null;
    }

    private FeatureIterator(FeatureAdapter adapter, Connection connection, InfoStatements spatialInformation) throws SQLException {
        this.spatialInformation = spatialInformation;
        this.adapter = adapter;
        this.statement = connection.prepareStatement(adapter.sql);
        this.dependencies = new FeatureIterator[adapter.dependencies.length];
        this.projection = null;
        this.estimatedSize = 0L;
    }

    private FeatureIterator dependency(int i) throws SQLException {
        FeatureIterator dependency = this.dependencies[i];
        if (dependency == null) {
            this.dependencies[i] = dependency = new FeatureIterator(this.adapter.dependencies[i], this.result.getStatement().getConnection(), this.spatialInformation);
        }
        return dependency;
    }

    @Override
    public int characteristics() {
        return 256;
    }

    @Override
    public long estimateSize() {
        return this.estimatedSize > 0L ? this.estimatedSize : Long.MAX_VALUE;
    }

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> action) {
        try {
            return this.fetch(action, false);
        }
        catch (Exception e) {
            throw FeatureStream.cannotExecute(e);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> action) {
        try {
            this.fetch(action, true);
        }
        catch (Exception e) {
            throw FeatureStream.cannotExecute(e);
        }
    }

    private boolean fetch(Consumer<? super AbstractFeature> action, boolean all) throws Exception {
        while (this.result.next()) {
            AbstractFeature feature = this.adapter.createFeature(this.spatialInformation, this.result);
            for (int i = 0; i < this.dependencies.length; ++i) {
                Object previous;
                WeakValueHashMap<?, Object> instances = null;
                Object key = null;
                Object value = null;
                if (i < this.adapter.importCount) {
                    key = this.adapter.getCacheKey(this.result, i);
                    if (key == null) continue;
                    instances = this.adapter.dependencies[i].instances;
                    value = instances.get(key);
                }
                if (value == null) {
                    FeatureIterator dependency = this.dependency(i);
                    this.adapter.setForeignerKeys(this.result, dependency.statement, i);
                    value = dependency.fetchReferenced(feature);
                }
                if (instances != null && (previous = instances.putIfAbsent(key, value)) != null) {
                    value = previous;
                }
                feature.setPropertyValue(this.adapter.associationNames[i], value);
            }
            if (this.projection != null) {
                feature = this.projection.apply(feature);
            }
            action.accept((AbstractFeature)feature);
            if (all) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchReferenced(AbstractFeature owner) throws Exception {
        ArrayList feature;
        ArrayList features = new ArrayList();
        try (ResultSet r = this.statement.executeQuery();){
            this.result = r;
            this.fetch(features::add, true);
        }
        finally {
            this.result = null;
        }
        if (owner != null && this.adapter.deferredAssociation != null) {
            for (AbstractFeature feature2 : features) {
                feature2.setPropertyValue(this.adapter.deferredAssociation, (Object)owner);
            }
        }
        switch (features.size()) {
            case 0: {
                feature = null;
                break;
            }
            case 1: {
                feature = features.get(0);
                break;
            }
            default: {
                feature = features;
            }
        }
        return feature;
    }

    @Override
    public void close() throws SQLException {
        ResultSet r;
        if (this.spatialInformation != null) {
            this.spatialInformation.close();
        }
        if (this.statement != null) {
            this.statement.close();
        }
        if ((r = this.result) != null) {
            this.result = null;
            Statement s = r.getStatement();
            try (Connection c = s.getConnection();){
                r.close();
                s.close();
                for (FeatureIterator dependency : this.dependencies) {
                    if (dependency == null) continue;
                    dependency.close();
                }
            }
        }
    }
}

