/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.referencing.internal.shared.ExtentSelector;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.metadata.extent.GeographicBoundingBox;

public abstract class MergeStrategy {
    protected MergeStrategy() {
    }

    public static MergeStrategy opaqueOverlay(Rectangle areaOfInterest) {
        Overlay strategy = Overlay.DEFAULT;
        if (areaOfInterest != null) {
            strategy = new Overlay(strategy.processor, new Rectangle(areaOfInterest));
        }
        return strategy;
    }

    public static MergeStrategy selectByTimeThenArea(Duration timeGranularity) {
        return timeGranularity != null ? new FilterByTime(timeGranularity) : FilterByTime.DEFAULT;
    }

    public Resource apply(Resource resource) {
        if (resource instanceof AggregatedResource) {
            return ((AggregatedResource)resource).apply(this);
        }
        return resource;
    }

    protected int[] filter(GridGeometry request, GridGeometry[] candidates) {
        return ArraysExt.range((int)0, (int)candidates.length);
    }

    protected abstract RenderedImage aggregate(RenderedImage[] var1);

    private static final class Overlay
    extends MergeStrategy {
        static final Overlay DEFAULT = new Overlay(new ImageProcessor(), null);
        final ImageProcessor processor;
        private final Rectangle areaOfInterest;

        Overlay(ImageProcessor processor, Rectangle areaOfInterest) {
            this.processor = processor;
            this.areaOfInterest = areaOfInterest;
        }

        @Override
        protected RenderedImage aggregate(RenderedImage[] sources) {
            return this.processor.overlay(sources, this.areaOfInterest);
        }

        public String toString() {
            return Strings.toString(MergeStrategy.class, (Object[])new Object[]{null, "opaqueOverlay", "areaOfInterest", this.areaOfInterest});
        }
    }

    private static final class FilterByTime
    extends MergeStrategy {
        static final FilterByTime DEFAULT = new FilterByTime(null);
        private final Duration timeGranularity;

        FilterByTime(Duration timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        protected int[] filter(GridGeometry request, GridGeometry[] candidates) {
            int[] nArray;
            ExtentSelector selector = new ExtentSelector((GeographicBoundingBox)request.getGeographicExtent().orElse(null), (Temporal[])request.getTemporalExtent());
            if (this.timeGranularity != null) {
                selector.setTimeGranularity(this.timeGranularity);
                selector.alternateOrdering = true;
            }
            for (int i = 0; i < candidates.length; ++i) {
                GridGeometry candidate = candidates[i];
                if (candidate == null) continue;
                Instant[] t = candidate.getTemporalExtent();
                int n = t.length;
                selector.evaluate((GeographicBoundingBox)candidate.getGeographicExtent().orElse(null), (Temporal)(n == 0 ? null : t[0]), n == 0 ? null : t[n - 1], (Object)i);
            }
            Integer best = (Integer)selector.best();
            if (best != null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = best;
            } else {
                nArray = ArraysExt.EMPTY_INT;
            }
            return nArray;
        }

        @Override
        protected RenderedImage aggregate(RenderedImage[] sources) {
            return sources[0];
        }

        public String toString() {
            return Strings.toString(MergeStrategy.class, (Object[])new Object[]{null, "selectByTimeThenArea", "timeGranularity", this.timeGranularity});
        }
    }
}

