/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Vocabulary;

public final class LogHandler
extends Handler
implements StoreListener<WarningEvent> {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.gui");
    private static final int LIMIT = 1000;
    private static final LogHandler INSTANCE = new LogHandler();
    private final Destination systemLogs = new Destination();
    private final WeakHashMap<Resource, Destination> resourceLogs = new WeakHashMap();
    private final ConcurrentMap<Long, Destination> inProgress = new ConcurrentHashMap<Long, Destination>();

    private LogHandler() {
    }

    public static void register(boolean enabled) {
        Logger root = Logger.getLogger("");
        if (enabled) {
            root.addHandler(INSTANCE);
        } else {
            root.removeHandler(INSTANCE);
            INSTANCE.close();
        }
    }

    public static void installListener(Resource resource) {
        if (resource != null) {
            resource.addListener(WarningEvent.class, (StoreListener)INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirect(Resource source, Resource target) {
        if (source != target && source != null && target != null) {
            WeakHashMap<Resource, Destination> weakHashMap = LogHandler.INSTANCE.resourceLogs;
            synchronized (weakHashMap) {
                LogHandler.INSTANCE.resourceLogs.putIfAbsent(target, LogHandler.getRecords(source));
            }
        }
    }

    public static Long loadingStart(Resource source) {
        if (source == null) {
            return null;
        }
        Long id = JDK19.threadId((Thread)Thread.currentThread());
        LogHandler.INSTANCE.inProgress.merge(id, LogHandler.getRecords(source), Destination::startNested);
        return id;
    }

    public static void loadingStop(Long id) {
        if (id != null) {
            LogHandler.INSTANCE.inProgress.computeIfPresent(id, (k, v) -> v.stopNested());
        }
    }

    public static Destination getSystemRecords() {
        return LogHandler.INSTANCE.systemLogs;
    }

    public static Destination getRecords(Resource source) {
        return source != null ? INSTANCE.getRecordsNonNull(source) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination getRecordsNonNull(Resource source) {
        WeakHashMap<Resource, Destination> weakHashMap = this.resourceLogs;
        synchronized (weakHashMap) {
            return this.resourceLogs.computeIfAbsent(source, k -> new Destination());
        }
    }

    public void eventOccured(WarningEvent event) {
        LogRecord log;
        Resource source = event.getSource();
        if (source != null && this.isLoggable(log = event.getDescription())) {
            Destination records = this.getRecordsNonNull(source);
            if (Platform.isFxApplicationThread()) {
                records.add(log);
            } else {
                Platform.runLater(() -> records.add(log));
            }
        }
    }

    @Override
    public void publish(LogRecord log) {
        if (this.isLoggable(log)) {
            Long id = log.getLongThreadID();
            Destination records = (Destination)this.inProgress.get(id);
            if (Platform.isFxApplicationThread()) {
                this.systemLogs.add(log);
                if (records != null) {
                    records.add(log);
                }
            } else {
                Platform.runLater(() -> {
                    this.systemLogs.add(log);
                    if (records != null) {
                        records.add(log);
                    }
                });
            }
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WeakHashMap<Resource, Destination> weakHashMap = this.resourceLogs;
        synchronized (weakHashMap) {
            this.resourceLogs.clear();
        }
        this.inProgress.clear();
    }

    public static final class Destination {
        private final ObservableList<LogRecord> queue = FXCollections.observableArrayList();
        public final ObservableList<LogRecord> records = FXCollections.unmodifiableObservableList(this.queue);
        private TreeMap<String, Integer> nameCount;
        private TreeItem<String> loggers;
        private final List<Destination> nested = new ArrayList<Destination>(3);

        Destination() {
        }

        final Destination startNested(Destination newer) {
            newer.nested.add(this);
            return newer;
        }

        final Destination stopNested() {
            int n = this.nested.size();
            return n != 0 ? this.nested.remove(n - 1) : null;
        }

        private static String[] path(LogRecord record) {
            return (String[])CharSequences.split((CharSequence)record.getLoggerName(), (char)'.');
        }

        public final void add(LogRecord record) {
            if (this.queue.add((Object)record)) {
                if (this.nameCount != null) {
                    this.updateTree(record);
                }
                while (this.queue.size() > 1000) {
                    Integer remaining;
                    String name;
                    LogRecord first = (LogRecord)this.queue.remove(0);
                    if (this.nameCount == null || (name = first.getLoggerName()) == null || (remaining = this.nameCount.computeIfPresent(name, (k, o) -> {
                        int v = o - 1;
                        return v > 0 ? Integer.valueOf(v) : null;
                    })) != null) continue;
                    GUIUtilities.removePathSorted(this.loggers, (Comparable[])Destination.path(first));
                }
            }
        }

        private void updateTree(LogRecord record) {
            String name = record.getLoggerName();
            if (name != null && this.nameCount.merge(name, 1, (o, n) -> o + 1) == 1) {
                GUIUtilities.appendPathSorted(this.loggers, (Comparable[])Destination.path(record));
            }
        }

        public TreeItem<String> loggerNames() {
            if (this.loggers == null) {
                this.nameCount = new TreeMap();
                this.loggers = new TreeItem((Object)Vocabulary.format((short)176));
                this.queue.forEach(this::updateTree);
                this.loggers.setExpanded(true);
            }
            return this.loggers;
        }
    }
}

