/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoDynamicClassRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.ClassID, (node, tokenQuery, problems) -> this.checkClassNode((IClassNode)node, tokenQuery, problems));
        return result;
    }

    private void checkClassNode(IClassNode classNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!classNode.hasModifier(ASModifier.DYNAMIC)) {
            return;
        }
        problems.add(new NoDynamicClassLinterProblem(classNode));
    }

    public static class NoDynamicClassLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Class '${className}' must not be dynamic";
        public String className;

        public NoDynamicClassLinterProblem(IClassNode node) {
            super((ISourceLocation)node);
            this.className = node.getName();
        }
    }
}

