/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client.rebalance;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class RebalanceLockManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRebalanceLock");
    private static final long REBALANCE_LOCK_MAX_LIVE_TIME = Long.parseLong(System.getProperty("rocketmq.broker.rebalance.lockMaxLiveTime", "60000"));
    private final Lock lock = new ReentrantLock();
    private final ConcurrentMap<String, ConcurrentHashMap<MessageQueue, LockEntry>> mqLockTable = new ConcurrentHashMap<String, ConcurrentHashMap<MessageQueue, LockEntry>>(1024);

    public boolean isLockAllExpired(String group) {
        ConcurrentHashMap lockEntryMap = (ConcurrentHashMap)this.mqLockTable.get(group);
        if (null == lockEntryMap) {
            return true;
        }
        for (LockEntry entry : lockEntryMap.values()) {
            if (entry.isExpired()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock(String group, MessageQueue mq, String clientId) {
        if (this.isLocked(group, mq, clientId)) return true;
        try {
            this.lock.lockInterruptibly();
            try {
                LockEntry lockEntry;
                ConcurrentHashMap<MessageQueue, LockEntry> groupValue = (ConcurrentHashMap<MessageQueue, LockEntry>)this.mqLockTable.get(group);
                if (null == groupValue) {
                    groupValue = new ConcurrentHashMap<MessageQueue, LockEntry>(32);
                    this.mqLockTable.put(group, groupValue);
                }
                if (null == (lockEntry = (LockEntry)groupValue.get(mq))) {
                    lockEntry = new LockEntry();
                    lockEntry.setClientId(clientId);
                    groupValue.put(mq, lockEntry);
                    log.info("RebalanceLockManager#tryLock: lock a message queue which has not been locked yet, group={}, clientId={}, mq={}", new Object[]{group, clientId, mq});
                }
                if (lockEntry.isLocked(clientId)) {
                    lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                    boolean bl = true;
                    return bl;
                }
                String oldClientId = lockEntry.getClientId();
                if (lockEntry.isExpired()) {
                    lockEntry.setClientId(clientId);
                    lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                    log.warn("RebalanceLockManager#tryLock: try to lock a expired message queue, group={}, mq={}, old client id={}, new client id={}", new Object[]{group, mq, oldClientId, clientId});
                    boolean bl = true;
                    return bl;
                }
                log.warn("RebalanceLockManager#tryLock: message queue has been locked by other client, group={}, mq={}, locked client id={}, current client id={}", new Object[]{group, mq, oldClientId, clientId});
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("RebalanceLockManager#tryLock: unexpected error, group={}, mq={}, clientId={}", new Object[]{group, mq, clientId, e});
        }
        return true;
    }

    private boolean isLocked(String group, MessageQueue mq, String clientId) {
        LockEntry lockEntry;
        ConcurrentHashMap groupValue = (ConcurrentHashMap)this.mqLockTable.get(group);
        if (groupValue != null && (lockEntry = (LockEntry)groupValue.get(mq)) != null) {
            boolean locked = lockEntry.isLocked(clientId);
            if (locked) {
                lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
            }
            return locked;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageQueue> tryLockBatch(String group, Set<MessageQueue> mqs, String clientId) {
        HashSet<MessageQueue> lockedMqs = new HashSet<MessageQueue>(mqs.size());
        HashSet<MessageQueue> notLockedMqs = new HashSet<MessageQueue>(mqs.size());
        for (MessageQueue mq : mqs) {
            if (this.isLocked(group, mq, clientId)) {
                lockedMqs.add(mq);
                continue;
            }
            notLockedMqs.add(mq);
        }
        if (!notLockedMqs.isEmpty()) {
            try {
                this.lock.lockInterruptibly();
                try {
                    ConcurrentHashMap<MessageQueue, LockEntry> groupValue = (ConcurrentHashMap<MessageQueue, LockEntry>)this.mqLockTable.get(group);
                    if (null == groupValue) {
                        groupValue = new ConcurrentHashMap<MessageQueue, LockEntry>(32);
                        this.mqLockTable.put(group, groupValue);
                    }
                    for (MessageQueue mq : notLockedMqs) {
                        LockEntry lockEntry = (LockEntry)groupValue.get(mq);
                        if (null == lockEntry) {
                            lockEntry = new LockEntry();
                            lockEntry.setClientId(clientId);
                            groupValue.put(mq, lockEntry);
                            log.info("RebalanceLockManager#tryLockBatch: lock a message which has not been locked yet, group={}, clientId={}, mq={}", new Object[]{group, clientId, mq});
                        }
                        if (lockEntry.isLocked(clientId)) {
                            lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                            lockedMqs.add(mq);
                            continue;
                        }
                        String oldClientId = lockEntry.getClientId();
                        if (lockEntry.isExpired()) {
                            lockEntry.setClientId(clientId);
                            lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                            log.warn("RebalanceLockManager#tryLockBatch: try to lock a expired message queue, group={}, mq={}, old client id={}, new client id={}", new Object[]{group, mq, oldClientId, clientId});
                            lockedMqs.add(mq);
                            continue;
                        }
                        log.warn("RebalanceLockManager#tryLockBatch: message queue has been locked by other client, group={}, mq={}, locked client id={}, current client id={}", new Object[]{group, mq, oldClientId, clientId});
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("RebalanceLockManager#tryBatch: unexpected error, group={}, mqs={}, clientId={}", new Object[]{group, mqs, clientId, e});
            }
        }
        return lockedMqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockBatch(String group, Set<MessageQueue> mqs, String clientId) {
        try {
            this.lock.lockInterruptibly();
            try {
                ConcurrentHashMap groupValue = (ConcurrentHashMap)this.mqLockTable.get(group);
                if (null != groupValue) {
                    for (MessageQueue mq : mqs) {
                        LockEntry lockEntry = (LockEntry)groupValue.get(mq);
                        if (null != lockEntry) {
                            if (lockEntry.getClientId().equals(clientId)) {
                                groupValue.remove(mq);
                                log.info("RebalanceLockManager#unlockBatch: unlock mq, group={}, clientId={}, mqs={}", new Object[]{group, clientId, mq});
                                continue;
                            }
                            log.warn("RebalanceLockManager#unlockBatch: mq locked by other client, group={}, locked clientId={}, current clientId={}, mqs={}", new Object[]{group, lockEntry.getClientId(), clientId, mq});
                            continue;
                        }
                        log.warn("RebalanceLockManager#unlockBatch: mq not locked, group={}, clientId={}, mq={}", new Object[]{group, clientId, mq});
                    }
                } else {
                    log.warn("RebalanceLockManager#unlockBatch: group not exist, group={}, clientId={}, mqs={}", new Object[]{group, clientId, mqs});
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("RebalanceLockManager#unlockBatch: unexpected error, group={}, mqs={}, clientId={}", new Object[]{group, mqs, clientId});
        }
    }

    static class LockEntry {
        private String clientId;
        private volatile long lastUpdateTimestamp = System.currentTimeMillis();

        LockEntry() {
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public long getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public void setLastUpdateTimestamp(long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public boolean isLocked(String clientId) {
            boolean eq = this.clientId.equals(clientId);
            return eq && !this.isExpired();
        }

        public boolean isExpired() {
            boolean expired = System.currentTimeMillis() - this.lastUpdateTimestamp > REBALANCE_LOCK_MAX_LIVE_TIME;
            return expired;
        }
    }
}

