/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import java.nio.ByteBuffer;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;

public class ByteBufferBinding
extends TupleBinding<QpidByteBuffer> {
    private static final int COPY_BUFFER_SIZE = 8192;
    private static final ThreadLocal<byte[]> COPY_BUFFER = ThreadLocal.withInitial(() -> new byte[8192]);
    private static final ByteBufferBinding INSTANCE = new ByteBufferBinding();

    public static ByteBufferBinding getInstance() {
        return INSTANCE;
    }

    private ByteBufferBinding() {
    }

    public QpidByteBuffer entryToObject(TupleInput input) {
        int available = input.available();
        QpidByteBuffer buf = QpidByteBuffer.allocateDirect((int)available);
        byte[] copyBuf = COPY_BUFFER.get();
        while (available > 0) {
            int read = input.read(copyBuf);
            buf.put(copyBuf, 0, read);
            available = input.available();
        }
        buf.flip();
        return buf;
    }

    public void objectToEntry(QpidByteBuffer data, TupleOutput output) {
        try (QpidByteBuffer dup = data.duplicate();){
            byte[] copyBuf = COPY_BUFFER.get();
            while (dup.hasRemaining()) {
                int length = Math.min(8192, dup.remaining());
                dup.get(copyBuf, 0, length);
                output.write(copyBuf, 0, length);
            }
        }
    }

    public ByteBuffer readByteBuffer(TupleInput input, int length) {
        ByteBuffer buf = ByteBuffer.allocateDirect(length);
        byte[] copyBuf = COPY_BUFFER.get();
        while (length > 0) {
            int read = input.read(copyBuf, 0, Math.min(8192, length));
            buf.put(copyBuf, 0, read);
            length -= read;
        }
        buf.flip();
        return buf;
    }
}

