/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;

public class RewriteLanguageRule
extends Rule {
    private static final HttpField VARY_ACCEPT_LANGUAGE = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_LANGUAGE.asString());
    private final BiFunction<String, String, String> _localizePath;
    private final BiFunction<Context, String, Resource> _getResource;
    private final List<String> _wildCardLanguages;

    public static String localizeWithSuffix(String pathInContext, String language) {
        if (pathInContext.isEmpty()) {
            return "/" + language + "/";
        }
        if (pathInContext.endsWith("/")) {
            return pathInContext + language + "/";
        }
        return pathInContext + "." + language;
    }

    public static String localizeWithPrefix(String pathInContext, String language) {
        return "/" + language + pathInContext;
    }

    public static Resource getResource(Context context, String pathInContext) {
        return context.getBaseResource().resolve(pathInContext);
    }

    public RewriteLanguageRule() {
        this(true);
    }

    public RewriteLanguageRule(List<String> wildCardLanguages) {
        this(RewriteLanguageRule::localizeWithPrefix, RewriteLanguageRule::getResource, wildCardLanguages);
    }

    public RewriteLanguageRule(boolean prefix) {
        this(prefix ? RewriteLanguageRule::localizeWithPrefix : RewriteLanguageRule::localizeWithSuffix, RewriteLanguageRule::getResource, null);
    }

    public RewriteLanguageRule(BiFunction<String, String, String> localizePath, BiFunction<Context, String, Resource> getResource) {
        this(localizePath, getResource, null);
    }

    public RewriteLanguageRule(BiFunction<String, String, String> localizePath, BiFunction<Context, String, Resource> getResource, List<String> wildCardLanguages) {
        this._localizePath = localizePath;
        this._getResource = getResource;
        this._wildCardLanguages = wildCardLanguages == null ? List.of() : Collections.unmodifiableList(wildCardLanguages);
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        List languages = input.getHeaders().getQualityCSV(HttpHeader.ACCEPT_LANGUAGE);
        if (languages != null && !languages.isEmpty()) {
            for (String language : languages) {
                if (language == null) continue;
                if ("*".equals(language)) {
                    for (String wildCardLanguage : this._wildCardLanguages) {
                        String pathInContext = Request.getPathInContext((Request)input);
                        String languagePathInContext = this._localizePath.apply(pathInContext, wildCardLanguage);
                        Resource resource = this._getResource.apply(input.getContext(), languagePathInContext);
                        if (!resource.exists()) continue;
                        return this.newLanguageHandler(input, languagePathInContext, wildCardLanguage);
                    }
                    continue;
                }
                String pathInContext = Request.getPathInContext((Request)input);
                String languagePathInContext = this._localizePath.apply(pathInContext, language);
                Resource resource = this._getResource.apply(input.getContext(), languagePathInContext);
                if (!resource.exists()) continue;
                return this.newLanguageHandler(input, languagePathInContext, language);
            }
        }
        return new VaryHandler(input);
    }

    @Override
    public String toString() {
        return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
    }

    protected List<String> getWildCardLanguages() {
        return this._wildCardLanguages;
    }

    protected Rule.Handler newLanguageHandler(Rule.Handler input, String languagePathInContext, String language) {
        return new LanguageHandler(input, languagePathInContext, language);
    }

    private void ensureVaryAcceptLanguages(Response response) {
        response.getHeaders().computeField(HttpHeader.VARY, (h, l) -> {
            if (l == null || l.isEmpty()) {
                return VARY_ACCEPT_LANGUAGE;
            }
            boolean acceptLanguage = false;
            StringBuilder vary = new StringBuilder();
            block0: for (HttpField field : l) {
                for (String value : field.getValues()) {
                    if (HttpHeader.ACCEPT_LANGUAGE.asString().equalsIgnoreCase(value)) {
                        acceptLanguage = true;
                        break block0;
                    }
                    if (!vary.isEmpty()) {
                        vary.append(", ");
                    }
                    vary.append(value);
                }
            }
            if (!acceptLanguage) {
                vary.append(", ").append(HttpHeader.ACCEPT_LANGUAGE.asString());
            }
            return new HttpField(HttpHeader.VARY, vary.toString());
        });
    }

    protected class VaryHandler
    extends Rule.Handler {
        public VaryHandler(Rule.Handler input) {
            super(input);
        }

        @Override
        protected boolean handle(Response response, Callback callback) throws Exception {
            RewriteLanguageRule.this.ensureVaryAcceptLanguages(response);
            return super.handle(response, callback);
        }
    }

    protected class LanguageHandler
    extends Rule.Handler {
        private static final EnumSet<HttpHeader> IF_MATCHES = EnumSet.of(HttpHeader.IF_MATCH, HttpHeader.IF_NONE_MATCH);
        private final String _dashLanguage;
        private final HttpURI _languageURI;
        private final HttpField _languageField;
        private final HttpFields _httpFields;

        public LanguageHandler(Rule.Handler input, String languagePathInContext, String language) {
            super(input);
            this._dashLanguage = "-" + language;
            this._languageURI = HttpURI.build((HttpURI)input.getHttpURI()).path(URIUtil.addPaths((String)input.getContext().getContextPath(), (String)languagePathInContext)).asImmutable();
            this._languageField = new HttpField(HttpHeader.CONTENT_LANGUAGE, language);
            HttpFields httpFields = input.getHeaders();
            if (httpFields.contains(IF_MATCHES)) {
                httpFields = HttpFields.build((HttpFields)httpFields).computeField(HttpHeader.IF_MATCH, this::computeNoLangEtag).computeField(HttpHeader.IF_NONE_MATCH, this::computeNoLangEtag).asImmutable();
            }
            this._httpFields = httpFields;
        }

        private HttpField computeNoLangEtag(HttpHeader header, List<HttpField> fields) {
            if (fields == null || fields.isEmpty()) {
                return null;
            }
            return new HttpField(header, fields.stream().flatMap(field -> field.getValueList(true).stream()).map(value -> value.replace(this._dashLanguage, "")).collect(Collectors.joining(", ")));
        }

        public HttpURI getHttpURI() {
            return this._languageURI;
        }

        public HttpFields getHeaders() {
            return this._httpFields;
        }

        @Override
        protected boolean handle(Response response, Callback callback) throws Exception {
            response.getHeaders().computeField(HttpHeader.CONTENT_LANGUAGE, (h, l) -> {
                if (l == null || l.isEmpty()) {
                    return this._languageField;
                }
                return (HttpField)l.get(0);
            });
            RewriteLanguageRule.this.ensureVaryAcceptLanguages(response);
            HttpFields.Mutable.Wrapper responseFields = new HttpFields.Mutable.Wrapper(response.getHeaders()){

                public HttpField onAddField(HttpField field) {
                    String etag;
                    if (field.getHeader() == HttpHeader.ETAG && (etag = field.getValue()).endsWith("\"")) {
                        return new HttpField(HttpHeader.ETAG, etag.substring(0, etag.length() - 1) + LanguageHandler.this._dashLanguage + "\"");
                    }
                    return field;
                }

                public HttpField onReplaceField(HttpField oldField, HttpField newField) {
                    if (oldField.getHeader() == HttpHeader.VARY && !newField.getValue().contains(HttpHeader.ACCEPT_LANGUAGE.asString())) {
                        return new HttpField(HttpHeader.VARY, newField.getValue() + ", " + HttpHeader.ACCEPT_LANGUAGE.asString());
                    }
                    return this.onAddField(newField);
                }

                public boolean onRemoveField(HttpField field) {
                    return field.getHeader() != HttpHeader.VARY || !field.getValue().contains(HttpHeader.ACCEPT_LANGUAGE.asString());
                }
            };
            Response.Wrapper wrappedResponse = new Response.Wrapper(this, response.getRequest(), response, (HttpFields.Mutable)responseFields){
                final /* synthetic */ HttpFields.Mutable val$responseFields;
                final /* synthetic */ LanguageHandler this$1;
                {
                    this.val$responseFields = mutable;
                    this.this$1 = this$1;
                    super(arg0, arg1);
                }

                public HttpFields.Mutable getHeaders() {
                    return this.val$responseFields;
                }
            };
            return super.handle((Response)wrappedResponse, callback);
        }
    }
}

