/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.logback.AbstractBrokerLogger;
import org.apache.qpid.server.logging.logback.BrokerMemoryLogger;
import org.apache.qpid.server.logging.logback.LogRecord;
import org.apache.qpid.server.logging.logback.LogRecorder;
import org.apache.qpid.server.logging.logback.RecordEventAppender;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;

public class BrokerMemoryLoggerImpl
extends AbstractBrokerLogger<BrokerMemoryLoggerImpl>
implements BrokerMemoryLogger<BrokerMemoryLoggerImpl> {
    @ManagedAttributeField
    private int _maxRecords;
    private LogRecorder _logRecorder;

    @ManagedObjectFactoryConstructor
    protected BrokerMemoryLoggerImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public int getMaxRecords() {
        return this._maxRecords;
    }

    @Override
    protected void postResolveChildren() {
        int maxRecords = this.getMaxRecords();
        this.validateLimits(maxRecords);
        super.postResolveChildren();
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        BrokerMemoryLogger brokerMemoryLogger = (BrokerMemoryLogger)proxyForValidation;
        if (changedAttributes.contains("maxRecords")) {
            int maxRecords = brokerMemoryLogger.getMaxRecords();
            this.validateLimits(maxRecords);
        }
    }

    private void validateLimits(int maxRecords) {
        if (maxRecords > 16384) {
            throw new IllegalConfigurationException(String.format("Maximum number of records (%d) exceeds limit (%d)", maxRecords, 16384));
        }
        if (maxRecords < 1) {
            throw new IllegalConfigurationException(String.format("Maximum number of records (%d) must be larger than zero", maxRecords));
        }
    }

    @Override
    protected Appender<ILoggingEvent> createAppenderInstance(Context context) {
        if (this._logRecorder != null) {
            throw new IllegalStateException("RecordEventAppender is already created");
        }
        RecordEventAppender appender = new RecordEventAppender(this.getMaxRecords());
        this._logRecorder = new LogRecorder(appender);
        return appender;
    }

    @Override
    public Collection<LogRecord> getLogEntries(long lastLogId) {
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        for (LogRecord record : this._logRecorder) {
            if (record.getId() <= lastLogId) continue;
            logRecords.add(record);
        }
        return logRecords;
    }
}

