/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.AclFileParser;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleBasedAccessControl;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.plugins.AbstractLegacyAccessControlProvider;
import org.apache.qpid.server.security.access.plugins.AclRule;

abstract class AbstractCommonRuleBasedAccessControlProvider<X extends AbstractCommonRuleBasedAccessControlProvider<X, T, Y>, T extends EventLoggerProvider & ConfiguredObject<?>, Y extends CommonAccessControlProvider<Y>>
extends AbstractLegacyAccessControlProvider<X, T, Y>
implements EventLoggerProvider {
    @ManagedAttributeField
    private Result _defaultResult;
    @ManagedAttributeField
    private volatile List<AclRule> _rules;

    AbstractCommonRuleBasedAccessControlProvider(Map<String, Object> attributes, T parent) {
        super(attributes, parent);
    }

    protected void postSetAttributes(Set<String> actualUpdatedAttributes) {
        super.postSetAttributes(actualUpdatedAttributes);
        if (actualUpdatedAttributes.contains("defaultResult") || actualUpdatedAttributes.contains("rules")) {
            this.recreateAccessController();
        }
    }

    @Override
    protected RuleBasedAccessControl createRuleBasedAccessController() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (AclRule configuredRule : this._rules) {
            rules.add(new Rule(configuredRule));
        }
        return new RuleBasedAccessControl(RuleSet.newInstance(this, rules, this._defaultResult), this.getModel());
    }

    public Result getDefaultResult() {
        return this._defaultResult;
    }

    public List<AclRule> getRules() {
        return this._rules;
    }

    public void loadFromFile(String path) {
        RuleSet ruleSet = AclFileParser.parse(path, (EventLoggerProvider)this);
        ArrayList<AclRule> aclRules = new ArrayList<AclRule>();
        for (Rule rule : ruleSet) {
            aclRules.add(rule.asAclRule());
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("defaultResult", ruleSet.getDefault());
        attrs.put("rules", aclRules);
        this.setAttributes(attrs);
    }

    public Content extractRules() {
        StringBuilder sb = new StringBuilder();
        switch (this._defaultResult) {
            case DENIED: {
                break;
            }
            case ALLOWED: 
            case DEFER: {
                sb.append(String.format("CONFIG %s=true\n", this._defaultResult == Result.ALLOWED ? "defaultallow" : "defaultdefer"));
            }
        }
        for (AclRule rule : this._rules) {
            this.append(rule, sb);
            sb.append('\n');
        }
        return new StringContent(this.getName(), sb.toString());
    }

    private void append(AclRule rule, StringBuilder sb) {
        sb.append("ACL ").append(rule.getOutcome().name().replace('_', '-')).append(' ').append(rule.getIdentity()).append(' ').append(rule.getOperation().name()).append(' ').append(rule.getObjectType().name());
        for (Map.Entry<Property, Object> entry : rule.getAttributes().entrySet()) {
            if (entry.getValue() == null) continue;
            sb.append(' ').append(entry.getKey().getCanonicalName());
            if (entry.getValue() instanceof Collection) {
                Collection values = (Collection)entry.getValue();
                sb.append("=[\"").append(values.stream().map(Object::toString).collect(Collectors.joining("\",\""))).append("\"]");
                continue;
            }
            sb.append("=\"").append(entry.getValue()).append("\"");
        }
    }

    private static class StringContent
    implements Content,
    CustomRestHeaders {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss");
        private final String _content;
        private final String _name;

        public StringContent(String name, String content) {
            this._content = content;
            this._name = name;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this._content.getBytes(StandardCharsets.UTF_8));
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "text/plain";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return String.format("attachment; filename=\"%s-%s.acl\"", this._name, FORMATTER.format(LocalDateTime.now()));
        }

        public void release() {
        }
    }
}

