/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.util.UUID;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class UUIDTypeConstructor
implements TypeConstructor<UUID> {
    private static final UUIDTypeConstructor INSTANCE = new UUIDTypeConstructor();

    public static UUIDTypeConstructor getInstance() {
        return INSTANCE;
    }

    private UUIDTypeConstructor() {
    }

    @Override
    public UUID construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining(16)) {
            long msb = in.getLong();
            long lsb = in.getLong();
            return new UUID(msb, lsb);
        }
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct UUID: insufficient input data", new Object[0]);
    }
}

