/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequenceSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationPropertiesSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DataSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeliveryAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.FooterSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.HeaderSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.PropertiesSection;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class Message_1_0
extends AbstractServerMessageImpl<Message_1_0, MessageMetaData_1_0> {
    private static final AMQPDescribedTypeRegistry DESCRIBED_TYPE_REGISTRY = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();
    private static final MessageMetaData_1_0 DELETED_MESSAGE_METADATA = new MessageMetaData_1_0(null, null, null, null, null, null, 0L, 0L);
    private static final String AMQP_1_0 = "AMQP 1.0";

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage) {
        super(storedMessage, null);
    }

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage, Object connectionReference) {
        super(storedMessage, connectionReference);
    }

    public String getInitialRoutingAddress() {
        MessageMetaData_1_0.MessageHeader_1_0 messageHeader = this.getMessageHeader();
        String routingAddress = messageHeader.getHeader("routing-key") instanceof String ? (String)messageHeader.getHeader("routing-key") : (messageHeader.getHeader("routing_key") instanceof String ? (String)messageHeader.getHeader("routing_key") : (messageHeader.getSubject() != null ? messageHeader.getSubject() : ""));
        return routingAddress;
    }

    public String getTo() {
        MessageMetaData_1_0.MessageHeader_1_0 messageHeader = this.getMessageHeader();
        return messageHeader.getTo();
    }

    private MessageMetaData_1_0 getMessageMetaData() {
        MessageMetaData_1_0 metaData = (MessageMetaData_1_0)this.getStoredMessage().getMetaData();
        return metaData == null ? DELETED_MESSAGE_METADATA : metaData;
    }

    public MessageMetaData_1_0.MessageHeader_1_0 getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    public long getExpiration() {
        return this.getMessageMetaData().getMessageHeader().getExpiration();
    }

    public String getMessageType() {
        return AMQP_1_0;
    }

    public long getArrivalTime() {
        return this.getMessageMetaData().getArrivalTime();
    }

    public boolean isResourceAcceptable(TransactionLogResource resource) {
        return this.getMessageHeader().getNotValidBefore() == 0L || this.resourceSupportsDeliveryDelay(resource);
    }

    private boolean resourceSupportsDeliveryDelay(TransactionLogResource resource) {
        return resource instanceof Queue && ((Queue)resource).isHoldOnPublishEnabled();
    }

    public HeaderSection getHeaderSection() {
        return this.getMessageMetaData().getHeaderSection();
    }

    public PropertiesSection getPropertiesSection() {
        return this.getMessageMetaData().getPropertiesSection();
    }

    public DeliveryAnnotationsSection getDeliveryAnnotationsSection() {
        return this.getMessageMetaData().getDeliveryAnnotationsSection();
    }

    public MessageAnnotationsSection getMessageAnnotationsSection() {
        return this.getMessageMetaData().getMessageAnnotationsSection();
    }

    public ApplicationPropertiesSection getApplicationPropertiesSection() {
        return this.getMessageMetaData().getApplicationPropertiesSection();
    }

    public FooterSection getFooterSection() {
        return this.getMessageMetaData().getFooterSection();
    }

    public QpidByteBuffer getContent(int offset, int length) {
        if (this.getMessageMetaData().getVersion() == 0) {
            QpidByteBuffer qpidByteBuffer;
            block18: {
                List<EncodingRetainingSection<?>> sections;
                SectionDecoderImpl sectionDecoder = new SectionDecoderImpl(DESCRIBED_TYPE_REGISTRY.getSectionDecoderRegistry());
                try (QpidByteBuffer allSectionsContent = super.getContent(0, Integer.MAX_VALUE);){
                    sections = sectionDecoder.parseAll(allSectionsContent);
                }
                ArrayList<QpidByteBuffer> bodySectionContent = new ArrayList<QpidByteBuffer>();
                for (EncodingRetainingSection<?> section : sections) {
                    if (section instanceof DataSection || section instanceof AmqpValueSection || section instanceof AmqpSequenceSection) {
                        bodySectionContent.add(section.getEncodedForm());
                    }
                    section.dispose();
                }
                QpidByteBuffer bodyContent = QpidByteBuffer.concatenate(bodySectionContent);
                try {
                    bodySectionContent.forEach(QpidByteBuffer::dispose);
                    qpidByteBuffer = bodyContent.view(offset, length);
                    if (bodyContent == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (bodyContent != null) {
                            try {
                                bodyContent.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (AmqpErrorException e) {
                        throw new ConnectionScopedRuntimeException((Throwable)e);
                    }
                }
                bodyContent.close();
            }
            return qpidByteBuffer;
        }
        return super.getContent(offset, length);
    }
}

