/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.plugin.MessageFormat;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoder;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorRuntimeException;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequenceSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationPropertiesSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DataSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeliveryAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.FooterSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.HeaderSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.PropertiesSection;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class MessageFormat_1_0
implements MessageFormat<Message_1_0> {
    public static final int AMQP_MESSAGE_FORMAT_1_0 = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFormat_1_0.class);
    private final SectionDecoder _sectionDecoder = new SectionDecoderImpl(AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer().registerExtensionSoleconnLayer().getSectionDecoderRegistry());

    public String getType() {
        return "AMQP_1_0";
    }

    public int getSupportedFormat() {
        return 0;
    }

    public Class<Message_1_0> getMessageClass() {
        return Message_1_0.class;
    }

    public QpidByteBuffer convertToMessageFormat(Message_1_0 message) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Message_1_0 createMessage(QpidByteBuffer payload, MessageStore store, Object connectionReference) {
        List<EncodingRetainingSection<?>> allSections;
        ArrayList dataSections = new ArrayList();
        try {
            allSections = this.getSectionDecoder().parseAll(payload);
        }
        catch (AmqpErrorException e) {
            throw new AmqpErrorRuntimeException(e);
        }
        MessageMetaData_1_0 mmd = this.createMessageMetaData(allSections, dataSections);
        MessageHandle handle = store.addMessage((StorableMessageMetaData)mmd);
        for (EncodingRetainingSection encodingRetainingSection : dataSections) {
            try (QpidByteBuffer encodedForm = encodingRetainingSection.getEncodedForm();){
                handle.addContent(encodedForm);
            }
            encodingRetainingSection.dispose();
        }
        StoredMessage storedMessage = handle.allContentAdded();
        return new Message_1_0((StoredMessage<MessageMetaData_1_0>)storedMessage, connectionReference);
    }

    private MessageMetaData_1_0 createMessageMetaData(List<EncodingRetainingSection<?>> allSections, List<EncodingRetainingSection<?>> dataSections) {
        EncodingRetainingSection<?> s;
        long contentSize = 0L;
        HeaderSection headerSection = null;
        PropertiesSection propertiesSection = null;
        DeliveryAnnotationsSection deliveryAnnotationsSection = null;
        MessageAnnotationsSection messageAnnotationsSection = null;
        ApplicationPropertiesSection applicationPropertiesSection = null;
        FooterSection footerSection = null;
        Iterator<EncodingRetainingSection<?>> iter = allSections.iterator();
        EncodingRetainingSection<?> encodingRetainingSection = s = iter.hasNext() ? iter.next() : null;
        if (s instanceof HeaderSection) {
            headerSection = (HeaderSection)s;
            EncodingRetainingSection<?> encodingRetainingSection2 = s = iter.hasNext() ? iter.next() : null;
        }
        if (s instanceof DeliveryAnnotationsSection) {
            deliveryAnnotationsSection = (DeliveryAnnotationsSection)s;
            EncodingRetainingSection<?> encodingRetainingSection3 = s = iter.hasNext() ? iter.next() : null;
        }
        if (s instanceof MessageAnnotationsSection) {
            messageAnnotationsSection = (MessageAnnotationsSection)s;
            EncodingRetainingSection<?> encodingRetainingSection4 = s = iter.hasNext() ? iter.next() : null;
        }
        if (s instanceof PropertiesSection) {
            propertiesSection = (PropertiesSection)s;
            EncodingRetainingSection<?> encodingRetainingSection5 = s = iter.hasNext() ? iter.next() : null;
        }
        if (s instanceof ApplicationPropertiesSection) {
            applicationPropertiesSection = (ApplicationPropertiesSection)s;
            EncodingRetainingSection<?> encodingRetainingSection6 = s = iter.hasNext() ? iter.next() : null;
        }
        if (s instanceof AmqpValueSection) {
            contentSize = s.getEncodedSize();
            dataSections.add(s);
            s = iter.hasNext() ? iter.next() : null;
        } else if (s instanceof DataSection) {
            do {
                contentSize += s.getEncodedSize();
                dataSections.add(s);
            } while ((s = iter.hasNext() ? iter.next() : null) instanceof DataSection);
        } else if (s instanceof AmqpSequenceSection) {
            do {
                contentSize += s.getEncodedSize();
                dataSections.add(s);
            } while ((s = iter.hasNext() ? iter.next() : null) instanceof AmqpSequenceSection);
        }
        if (s instanceof FooterSection) {
            footerSection = (FooterSection)s;
            EncodingRetainingSection<?> encodingRetainingSection7 = s = iter.hasNext() ? iter.next() : null;
        }
        if (s != null) {
            throw new ConnectionScopedRuntimeException(String.format("Encountered unexpected section '%s'", s.getClass().getSimpleName()));
        }
        return new MessageMetaData_1_0(headerSection, deliveryAnnotationsSection, messageAnnotationsSection, propertiesSection, applicationPropertiesSection, footerSection, System.currentTimeMillis(), contentSize);
    }

    private SectionDecoder getSectionDecoder() {
        return this._sectionDecoder;
    }
}

